// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Virtual Machine operation response.
 */
@Fluent
public final class VirtualMachineScaleSetListWithLinkResult
    implements JsonSerializable<VirtualMachineScaleSetListWithLinkResult> {
    /*
     * The list of virtual machine scale sets.
     */
    private List<VirtualMachineScaleSetInner> value;

    /*
     * The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with this to fetch the next page of
     * Virtual Machine Scale Sets.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualMachineScaleSetListWithLinkResult class.
     */
    public VirtualMachineScaleSetListWithLinkResult() {
    }

    /**
     * Get the value property: The list of virtual machine scale sets.
     * 
     * @return the value value.
     */
    public List<VirtualMachineScaleSetInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of virtual machine scale sets.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineScaleSetListWithLinkResult object itself.
     */
    public VirtualMachineScaleSetListWithLinkResult withValue(List<VirtualMachineScaleSetInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with
     * this to fetch the next page of Virtual Machine Scale Sets.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext() with
     * this to fetch the next page of Virtual Machine Scale Sets.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualMachineScaleSetListWithLinkResult object itself.
     */
    public VirtualMachineScaleSetListWithLinkResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model VirtualMachineScaleSetListWithLinkResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetListWithLinkResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetListWithLinkResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetListWithLinkResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetListWithLinkResult.
     */
    public static VirtualMachineScaleSetListWithLinkResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetListWithLinkResult deserializedVirtualMachineScaleSetListWithLinkResult
                = new VirtualMachineScaleSetListWithLinkResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualMachineScaleSetInner> value
                        = reader.readArray(reader1 -> VirtualMachineScaleSetInner.fromJson(reader1));
                    deserializedVirtualMachineScaleSetListWithLinkResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetListWithLinkResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetListWithLinkResult;
        });
    }
}
