// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes scaling information of a sku.
 */
@Immutable
public final class VirtualMachineScaleSetSkuCapacity implements JsonSerializable<VirtualMachineScaleSetSkuCapacity> {
    /*
     * The minimum capacity.
     */
    private Long minimum;

    /*
     * The maximum capacity that can be set.
     */
    private Long maximum;

    /*
     * The default capacity.
     */
    private Long defaultCapacity;

    /*
     * The scale type applicable to the sku.
     */
    private VirtualMachineScaleSetSkuScaleType scaleType;

    /**
     * Creates an instance of VirtualMachineScaleSetSkuCapacity class.
     */
    public VirtualMachineScaleSetSkuCapacity() {
    }

    /**
     * Get the minimum property: The minimum capacity.
     * 
     * @return the minimum value.
     */
    public Long minimum() {
        return this.minimum;
    }

    /**
     * Get the maximum property: The maximum capacity that can be set.
     * 
     * @return the maximum value.
     */
    public Long maximum() {
        return this.maximum;
    }

    /**
     * Get the defaultCapacity property: The default capacity.
     * 
     * @return the defaultCapacity value.
     */
    public Long defaultCapacity() {
        return this.defaultCapacity;
    }

    /**
     * Get the scaleType property: The scale type applicable to the sku.
     * 
     * @return the scaleType value.
     */
    public VirtualMachineScaleSetSkuScaleType scaleType() {
        return this.scaleType;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetSkuCapacity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetSkuCapacity if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetSkuCapacity.
     */
    public static VirtualMachineScaleSetSkuCapacity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetSkuCapacity deserializedVirtualMachineScaleSetSkuCapacity
                = new VirtualMachineScaleSetSkuCapacity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minimum".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetSkuCapacity.minimum = reader.getNullable(JsonReader::getLong);
                } else if ("maximum".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetSkuCapacity.maximum = reader.getNullable(JsonReader::getLong);
                } else if ("defaultCapacity".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetSkuCapacity.defaultCapacity
                        = reader.getNullable(JsonReader::getLong);
                } else if ("scaleType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetSkuCapacity.scaleType
                        = VirtualMachineScaleSetSkuScaleType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetSkuCapacity;
        });
    }
}
