// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileVersionInner;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileVersionUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * GalleryInVMAccessControlProfileVersionsClient.
 */
public interface GalleryInVMAccessControlProfileVersionsClient {
    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be created.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion);

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be created.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion);

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be created.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion);

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be created.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context);

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be created.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInVMAccessControlProfileVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion);

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be created.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileVersionInner createOrUpdate(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion);

    /**
     * Create or update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be created.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the create or update gallery
     * inVMAccessControlProfile version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileVersionInner createOrUpdate(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context);

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be updated.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion);

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be updated.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion);

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be updated.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion);

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be updated.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * version that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner>
        beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            String inVMAccessControlProfileVersionName,
            GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context);

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be updated.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInVMAccessControlProfileVersionInner> updateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion);

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be updated.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileVersionInner update(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion);

    /**
     * Update a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version is to be updated.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * updated. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must
     * be within the range of a 32-bit integer. Format: &lt;MajorVersion&gt;.&lt;MinorVersion&gt;.&lt;Patch&gt;.
     * @param galleryInVMAccessControlProfileVersion Parameters supplied to the update gallery inVMAccessControlProfile
     * version operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileVersionInner update(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName,
        GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context);

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<GalleryInVMAccessControlProfileVersionInner>> getWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName);

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInVMAccessControlProfileVersionInner> getAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName);

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GalleryInVMAccessControlProfileVersionInner> getWithResponse(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context);

    /**
     * Retrieves information about a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile version that you want to create or
     * update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileVersionInner get(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName);

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName);

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName);

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName);

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context);

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        String inVMAccessControlProfileVersionName);

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        String inVMAccessControlProfileVersionName);

    /**
     * Delete a gallery inVMAccessControlProfile version.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile in which the
     * inVMAccessControlProfile version resides.
     * @param inVMAccessControlProfileVersionName The name of the gallery inVMAccessControlProfile version to be
     * deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        String inVMAccessControlProfileVersionName, Context context);

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile from which the
     * inVMAccessControlProfile versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfileAsync(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName);

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile from which the
     * inVMAccessControlProfile versions are to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfile(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName);

    /**
     * List gallery inVMAccessControlProfile versions in a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the inVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile from which the
     * inVMAccessControlProfile versions are to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfile Versions operation response as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfile(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context);
}
