// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetSkuCapacity;
import java.io.IOException;

/**
 * Describes an available virtual machine scale set sku.
 */
@Immutable
public final class VirtualMachineScaleSetSkuInner implements JsonSerializable<VirtualMachineScaleSetSkuInner> {
    /*
     * The type of resource the sku applies to.
     */
    private String resourceType;

    /*
     * The Sku.
     */
    private Sku sku;

    /*
     * Specifies the number of virtual machines in the scale set.
     */
    private VirtualMachineScaleSetSkuCapacity capacity;

    /**
     * Creates an instance of VirtualMachineScaleSetSkuInner class.
     */
    public VirtualMachineScaleSetSkuInner() {
    }

    /**
     * Get the resourceType property: The type of resource the sku applies to.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the sku property: The Sku.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Get the capacity property: Specifies the number of virtual machines in the scale set.
     * 
     * @return the capacity value.
     */
    public VirtualMachineScaleSetSkuCapacity capacity() {
        return this.capacity;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (capacity() != null) {
            capacity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetSkuInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetSkuInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetSkuInner.
     */
    public static VirtualMachineScaleSetSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetSkuInner deserializedVirtualMachineScaleSetSkuInner
                = new VirtualMachineScaleSetSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetSkuInner.resourceType = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetSkuInner.sku = Sku.fromJson(reader);
                } else if ("capacity".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetSkuInner.capacity
                        = VirtualMachineScaleSetSkuCapacity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetSkuInner;
        });
    }
}
