// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * This enumerates the possible sources of a disk's creation.
 */
public final class DiskCreateOption extends ExpandableStringEnum<DiskCreateOption> {
    /**
     * Static value Empty for DiskCreateOption.
     */
    public static final DiskCreateOption EMPTY = fromString("Empty");

    /**
     * Static value Attach for DiskCreateOption.
     */
    public static final DiskCreateOption ATTACH = fromString("Attach");

    /**
     * Static value FromImage for DiskCreateOption.
     */
    public static final DiskCreateOption FROM_IMAGE = fromString("FromImage");

    /**
     * Static value Import for DiskCreateOption.
     */
    public static final DiskCreateOption IMPORT = fromString("Import");

    /**
     * Static value Copy for DiskCreateOption.
     */
    public static final DiskCreateOption COPY = fromString("Copy");

    /**
     * Static value Restore for DiskCreateOption.
     */
    public static final DiskCreateOption RESTORE = fromString("Restore");

    /**
     * Static value Upload for DiskCreateOption.
     */
    public static final DiskCreateOption UPLOAD = fromString("Upload");

    /**
     * Static value CopyStart for DiskCreateOption.
     */
    public static final DiskCreateOption COPY_START = fromString("CopyStart");

    /**
     * Static value ImportSecure for DiskCreateOption.
     */
    public static final DiskCreateOption IMPORT_SECURE = fromString("ImportSecure");

    /**
     * Static value UploadPreparedSecure for DiskCreateOption.
     */
    public static final DiskCreateOption UPLOAD_PREPARED_SECURE = fromString("UploadPreparedSecure");

    /**
     * Static value CopyFromSanSnapshot for DiskCreateOption.
     */
    public static final DiskCreateOption COPY_FROM_SAN_SNAPSHOT = fromString("CopyFromSanSnapshot");

    /**
     * Creates a new instance of DiskCreateOption value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DiskCreateOption() {
    }

    /**
     * Creates or finds a DiskCreateOption from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DiskCreateOption.
     */
    public static DiskCreateOption fromString(String name) {
        return fromString(name, DiskCreateOption.class);
    }

    /**
     * Gets known DiskCreateOption values.
     * 
     * @return known DiskCreateOption values.
     */
    public static Collection<DiskCreateOption> values() {
        return values(DiskCreateOption.class);
    }
}
