// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This is the disk image encryption base class.
 */
@Fluent
public class DiskImageEncryption implements JsonSerializable<DiskImageEncryption> {
    /*
     * A relative URI containing the resource ID of the disk encryption set.
     */
    private String diskEncryptionSetId;

    /**
     * Creates an instance of DiskImageEncryption class.
     */
    public DiskImageEncryption() {
    }

    /**
     * Get the diskEncryptionSetId property: A relative URI containing the resource ID of the disk encryption set.
     * 
     * @return the diskEncryptionSetId value.
     */
    public String diskEncryptionSetId() {
        return this.diskEncryptionSetId;
    }

    /**
     * Set the diskEncryptionSetId property: A relative URI containing the resource ID of the disk encryption set.
     * 
     * @param diskEncryptionSetId the diskEncryptionSetId value to set.
     * @return the DiskImageEncryption object itself.
     */
    public DiskImageEncryption withDiskEncryptionSetId(String diskEncryptionSetId) {
        this.diskEncryptionSetId = diskEncryptionSetId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskEncryptionSetId", this.diskEncryptionSetId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskImageEncryption from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskImageEncryption if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskImageEncryption.
     */
    public static DiskImageEncryption fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskImageEncryption deserializedDiskImageEncryption = new DiskImageEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskEncryptionSetId".equals(fieldName)) {
                    deserializedDiskImageEncryption.diskEncryptionSetId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskImageEncryption;
        });
    }
}
