// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This is the platform attribute of the image version.
 */
@Immutable
public final class PlatformAttribute implements JsonSerializable<PlatformAttribute> {
    /*
     * This property specifies the name of the platformAttribute. It is read-only.
     */
    private String name;

    /*
     * This property specifies the value of the corresponding name property. It is read-only.
     */
    private String value;

    /**
     * Creates an instance of PlatformAttribute class.
     */
    public PlatformAttribute() {
    }

    /**
     * Get the name property: This property specifies the name of the platformAttribute. It is read-only.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the value property: This property specifies the value of the corresponding name property. It is read-only.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PlatformAttribute from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PlatformAttribute if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PlatformAttribute.
     */
    public static PlatformAttribute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PlatformAttribute deserializedPlatformAttribute = new PlatformAttribute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedPlatformAttribute.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedPlatformAttribute.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPlatformAttribute;
        });
    }
}
