/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DiskRestorePointProperties
implements JsonSerializable<DiskRestorePointProperties> {
    private OffsetDateTime timeCreated;
    private String sourceResourceId;
    private OperatingSystemTypes osType;
    private HyperVGeneration hyperVGeneration;
    private PurchasePlanAutoGenerated purchasePlan;
    private SupportedCapabilities supportedCapabilities;
    private String familyId;
    private String sourceUniqueId;
    private Encryption encryption;
    private Boolean supportsHibernation;
    private NetworkAccessPolicy networkAccessPolicy;
    private PublicNetworkAccess publicNetworkAccess;
    private String diskAccessId;
    private Float completionPercent;
    private String replicationState;
    private String sourceResourceLocation;
    private DiskSecurityProfile securityProfile;
    private Integer logicalSectorSize;

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public DiskRestorePointProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public DiskRestorePointProperties withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public DiskRestorePointProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    public String familyId() {
        return this.familyId;
    }

    public String sourceUniqueId() {
        return this.sourceUniqueId;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public DiskRestorePointProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public DiskRestorePointProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DiskRestorePointProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public DiskRestorePointProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public Float completionPercent() {
        return this.completionPercent;
    }

    public DiskRestorePointProperties withCompletionPercent(Float completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    public String replicationState() {
        return this.replicationState;
    }

    public String sourceResourceLocation() {
        return this.sourceResourceLocation;
    }

    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public DiskRestorePointProperties withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public Integer logicalSectorSize() {
        return this.logicalSectorSize;
    }

    public void validate() {
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.supportedCapabilities() != null) {
            this.supportedCapabilities().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeJsonField("purchasePlan", (JsonSerializable)this.purchasePlan);
        jsonWriter.writeJsonField("supportedCapabilities", (JsonSerializable)this.supportedCapabilities);
        jsonWriter.writeBooleanField("supportsHibernation", this.supportsHibernation);
        jsonWriter.writeStringField("networkAccessPolicy", this.networkAccessPolicy == null ? null : this.networkAccessPolicy.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("diskAccessId", this.diskAccessId);
        jsonWriter.writeNumberField("completionPercent", (Number)this.completionPercent);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        return jsonWriter.writeEndObject();
    }

    public static DiskRestorePointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiskRestorePointProperties)jsonReader.readObject(reader -> {
            DiskRestorePointProperties deserializedDiskRestorePointProperties = new DiskRestorePointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeCreated".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.sourceResourceId = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                if ("purchasePlan".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.purchasePlan = PurchasePlanAutoGenerated.fromJson(reader);
                    continue;
                }
                if ("supportedCapabilities".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.supportedCapabilities = SupportedCapabilities.fromJson(reader);
                    continue;
                }
                if ("familyId".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.familyId = reader.getString();
                    continue;
                }
                if ("sourceUniqueId".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.sourceUniqueId = reader.getString();
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.encryption = Encryption.fromJson(reader);
                    continue;
                }
                if ("supportsHibernation".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.supportsHibernation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkAccessPolicy".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.networkAccessPolicy = NetworkAccessPolicy.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("diskAccessId".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.diskAccessId = reader.getString();
                    continue;
                }
                if ("completionPercent".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.completionPercent = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("replicationState".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.replicationState = reader.getString();
                    continue;
                }
                if ("sourceResourceLocation".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.sourceResourceLocation = reader.getString();
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.securityProfile = DiskSecurityProfile.fromJson(reader);
                    continue;
                }
                if ("logicalSectorSize".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.logicalSectorSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskRestorePointProperties;
        });
    }
}

