/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineRunCommandProperties;
import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.azure.resourcemanager.compute.models.RunCommandManagedIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandScriptSource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualMachineRunCommandInner
extends Resource {
    private VirtualMachineRunCommandProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private VirtualMachineRunCommandProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public VirtualMachineRunCommandInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineRunCommandInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public VirtualMachineRunCommandScriptSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public VirtualMachineRunCommandInner withSource(VirtualMachineRunCommandScriptSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public List<RunCommandInputParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public VirtualMachineRunCommandInner withParameters(List<RunCommandInputParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public List<RunCommandInputParameter> protectedParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().protectedParameters();
    }

    public VirtualMachineRunCommandInner withProtectedParameters(List<RunCommandInputParameter> protectedParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withProtectedParameters(protectedParameters);
        return this;
    }

    public Boolean asyncExecution() {
        return this.innerProperties() == null ? null : this.innerProperties().asyncExecution();
    }

    public VirtualMachineRunCommandInner withAsyncExecution(Boolean asyncExecution) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withAsyncExecution(asyncExecution);
        return this;
    }

    public String runAsUser() {
        return this.innerProperties() == null ? null : this.innerProperties().runAsUser();
    }

    public VirtualMachineRunCommandInner withRunAsUser(String runAsUser) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withRunAsUser(runAsUser);
        return this;
    }

    public String runAsPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().runAsPassword();
    }

    public VirtualMachineRunCommandInner withRunAsPassword(String runAsPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withRunAsPassword(runAsPassword);
        return this;
    }

    public Integer timeoutInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().timeoutInSeconds();
    }

    public VirtualMachineRunCommandInner withTimeoutInSeconds(Integer timeoutInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withTimeoutInSeconds(timeoutInSeconds);
        return this;
    }

    public String outputBlobUri() {
        return this.innerProperties() == null ? null : this.innerProperties().outputBlobUri();
    }

    public VirtualMachineRunCommandInner withOutputBlobUri(String outputBlobUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withOutputBlobUri(outputBlobUri);
        return this;
    }

    public String errorBlobUri() {
        return this.innerProperties() == null ? null : this.innerProperties().errorBlobUri();
    }

    public VirtualMachineRunCommandInner withErrorBlobUri(String errorBlobUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withErrorBlobUri(errorBlobUri);
        return this;
    }

    public RunCommandManagedIdentity outputBlobManagedIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().outputBlobManagedIdentity();
    }

    public VirtualMachineRunCommandInner withOutputBlobManagedIdentity(RunCommandManagedIdentity outputBlobManagedIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withOutputBlobManagedIdentity(outputBlobManagedIdentity);
        return this;
    }

    public RunCommandManagedIdentity errorBlobManagedIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().errorBlobManagedIdentity();
    }

    public VirtualMachineRunCommandInner withErrorBlobManagedIdentity(RunCommandManagedIdentity errorBlobManagedIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withErrorBlobManagedIdentity(errorBlobManagedIdentity);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public VirtualMachineRunCommandInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public Boolean treatFailureAsDeploymentFailure() {
        return this.innerProperties() == null ? null : this.innerProperties().treatFailureAsDeploymentFailure();
    }

    public VirtualMachineRunCommandInner withTreatFailureAsDeploymentFailure(Boolean treatFailureAsDeploymentFailure) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineRunCommandProperties();
        }
        this.innerProperties().withTreatFailureAsDeploymentFailure(treatFailureAsDeploymentFailure);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineRunCommandInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineRunCommandInner)((Object)jsonReader.readObject(reader -> {
            VirtualMachineRunCommandInner deserializedVirtualMachineRunCommandInner = new VirtualMachineRunCommandInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualMachineRunCommandInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandInner.innerProperties = VirtualMachineRunCommandProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineRunCommandInner;
        }));
    }
}

