/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.CloudServiceRoleInstancesClient;
import com.azure.resourcemanager.compute.fluent.models.RoleInstanceInner;
import com.azure.resourcemanager.compute.fluent.models.RoleInstanceViewInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.azure.resourcemanager.compute.models.RoleInstanceListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CloudServiceRoleInstancesClientImpl
implements CloudServiceRoleInstancesClient {
    private final CloudServiceRoleInstancesService service;
    private final ComputeManagementClientImpl client;

    CloudServiceRoleInstancesClientImpl(ComputeManagementClientImpl client) {
        this.service = (CloudServiceRoleInstancesService)RestProxy.create(CloudServiceRoleInstancesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.beginDeleteAsync(roleInstanceName, resourceGroupName, cloudServiceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginDeleteAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.beginDeleteAsync(roleInstanceName, resourceGroupName, cloudServiceName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginDeleteAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        this.deleteAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        this.deleteAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleInstanceInner>> getWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, InstanceViewTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", expand, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleInstanceInner>> getWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", expand, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleInstanceInner> getAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        InstanceViewTypes expand = null;
        return this.getWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, expand).flatMap(res -> Mono.justOrEmpty((Object)((RoleInstanceInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleInstanceInner> getWithResponse(String roleInstanceName, String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context) {
        return (Response)this.getWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleInstanceInner get(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        InstanceViewTypes expand = null;
        return (RoleInstanceInner)this.getWithResponse(roleInstanceName, resourceGroupName, cloudServiceName, expand, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleInstanceViewInner>> getInstanceViewWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInstanceView(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleInstanceViewInner>> getInstanceViewWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInstanceView(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleInstanceViewInner> getInstanceViewAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.getInstanceViewWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName).flatMap(res -> Mono.justOrEmpty((Object)((RoleInstanceViewInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleInstanceViewInner> getInstanceViewWithResponse(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return (Response)this.getInstanceViewWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleInstanceViewInner getInstanceView(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return (RoleInstanceViewInner)this.getInstanceViewWithResponse(roleInstanceName, resourceGroupName, cloudServiceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleInstanceInner>> listSinglePageAsync(String resourceGroupName, String cloudServiceName, InstanceViewTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", expand, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleInstanceListResult)res.getValue()).value(), ((RoleInstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleInstanceInner>> listSinglePageAsync(String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", expand, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleInstanceListResult)res.getValue()).value(), ((RoleInstanceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleInstanceInner> listAsync(String resourceGroupName, String cloudServiceName, InstanceViewTypes expand) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, cloudServiceName, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleInstanceInner> listAsync(String resourceGroupName, String cloudServiceName) {
        InstanceViewTypes expand = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, cloudServiceName, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleInstanceInner> listAsync(String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, cloudServiceName, expand, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleInstanceInner> list(String resourceGroupName, String cloudServiceName) {
        InstanceViewTypes expand = null;
        return new PagedIterable(this.listAsync(resourceGroupName, cloudServiceName, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleInstanceInner> list(String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, cloudServiceName, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restart(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestartAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.beginRestartAsync(roleInstanceName, resourceGroupName, cloudServiceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginRestartAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restartAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.beginRestartAsync(roleInstanceName, resourceGroupName, cloudServiceName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restartAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginRestartAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        this.restartAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        this.restartAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reimage(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.reimage(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginReimageAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginReimageAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReimage(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.beginReimageAsync(roleInstanceName, resourceGroupName, cloudServiceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReimage(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginReimageAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reimageAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.beginReimageAsync(roleInstanceName, resourceGroupName, cloudServiceName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> reimageAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginReimageAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reimage(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        this.reimageAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reimage(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        this.reimageAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> rebuildWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.rebuild(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> rebuildWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.rebuild(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRebuildAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.rebuildWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRebuildAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.rebuildWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRebuild(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.beginRebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRebuild(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginRebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rebuildAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.beginRebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> rebuildAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return this.beginRebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rebuild(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        this.rebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rebuild(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        this.rebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRemoteDesktopFileWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/x-rdp";
        return FluxUtil.withContext(context -> this.service.getRemoteDesktopFile(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/x-rdp", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> getRemoteDesktopFileWithResponseAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-04";
        String accept = "application/x-rdp";
        context = this.client.mergeContext(context);
        return this.service.getRemoteDesktopFile(this.client.getEndpoint(), roleInstanceName, resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2024-11-04", "application/x-rdp", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getRemoteDesktopFileAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return this.getRemoteDesktopFileWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName).flatMap(res -> Mono.justOrEmpty((Object)((BinaryData)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRemoteDesktopFileWithResponse(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return (Response)this.getRemoteDesktopFileWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getRemoteDesktopFile(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return (BinaryData)this.getRemoteDesktopFileWithResponse(roleInstanceName, resourceGroupName, cloudServiceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleInstanceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleInstanceListResult)res.getValue()).value(), ((RoleInstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleInstanceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleInstanceListResult)res.getValue()).value(), ((RoleInstanceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    public static interface CloudServiceRoleInstancesService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="roleInstanceName") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="cloudServiceName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<RoleInstanceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="roleInstanceName") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="cloudServiceName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$expand") InstanceViewTypes var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/instanceView")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<RoleInstanceViewInner>> getInstanceView(@HostParam(value="$host") String var1, @PathParam(value="roleInstanceName") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="cloudServiceName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<RoleInstanceListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$expand") InstanceViewTypes var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @PathParam(value="roleInstanceName") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="cloudServiceName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/reimage")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimage(@HostParam(value="$host") String var1, @PathParam(value="roleInstanceName") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="cloudServiceName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/rebuild")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> rebuild(@HostParam(value="$host") String var1, @PathParam(value="roleInstanceName") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="cloudServiceName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/remoteDesktopFile")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BinaryData>> getRemoteDesktopFile(@HostParam(value="$host") String var1, @PathParam(value="roleInstanceName") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="cloudServiceName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<RoleInstanceListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

