/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class KeyVaultSecretReference
implements JsonSerializable<KeyVaultSecretReference> {
    private String secretUrl;
    private SubResource sourceVault;
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSecretReference.class);

    public String secretUrl() {
        return this.secretUrl;
    }

    public KeyVaultSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

    public SubResource sourceVault() {
        return this.sourceVault;
    }

    public KeyVaultSecretReference withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    public void validate() {
        if (this.secretUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretUrl in model KeyVaultSecretReference"));
        }
        if (this.sourceVault() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceVault in model KeyVaultSecretReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretUrl", this.secretUrl);
        jsonWriter.writeJsonField("sourceVault", (JsonSerializable)this.sourceVault);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultSecretReference fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultSecretReference)jsonReader.readObject(reader -> {
            KeyVaultSecretReference deserializedKeyVaultSecretReference = new KeyVaultSecretReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("secretUrl".equals(fieldName)) {
                    deserializedKeyVaultSecretReference.secretUrl = reader.getString();
                    continue;
                }
                if ("sourceVault".equals(fieldName)) {
                    deserializedKeyVaultSecretReference.sourceVault = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultSecretReference;
        });
    }
}

