// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The CapacityReservationGroupInstanceView model.
 */
@Immutable
public final class CapacityReservationGroupInstanceView
    implements JsonSerializable<CapacityReservationGroupInstanceView> {
    /*
     * List of instance view of the capacity reservations under the capacity reservation group.
     */
    private List<CapacityReservationInstanceViewWithName> capacityReservations;

    /*
     * List of the subscriptions that the capacity reservation group is shared with. **Note:** Minimum api-version:
     * 2023-09-01. Please refer to https://aka.ms/computereservationsharing for more details.
     */
    private List<SubResourceReadOnly> sharedSubscriptionIds;

    /**
     * Creates an instance of CapacityReservationGroupInstanceView class.
     */
    public CapacityReservationGroupInstanceView() {
    }

    /**
     * Get the capacityReservations property: List of instance view of the capacity reservations under the capacity
     * reservation group.
     * 
     * @return the capacityReservations value.
     */
    public List<CapacityReservationInstanceViewWithName> capacityReservations() {
        return this.capacityReservations;
    }

    /**
     * Get the sharedSubscriptionIds property: List of the subscriptions that the capacity reservation group is shared
     * with. **Note:** Minimum api-version: 2023-09-01. Please refer to https://aka.ms/computereservationsharing for
     * more details.
     * 
     * @return the sharedSubscriptionIds value.
     */
    public List<SubResourceReadOnly> sharedSubscriptionIds() {
        return this.sharedSubscriptionIds;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capacityReservations() != null) {
            capacityReservations().forEach(e -> e.validate());
        }
        if (sharedSubscriptionIds() != null) {
            sharedSubscriptionIds().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CapacityReservationGroupInstanceView from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CapacityReservationGroupInstanceView if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CapacityReservationGroupInstanceView.
     */
    public static CapacityReservationGroupInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CapacityReservationGroupInstanceView deserializedCapacityReservationGroupInstanceView
                = new CapacityReservationGroupInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("capacityReservations".equals(fieldName)) {
                    List<CapacityReservationInstanceViewWithName> capacityReservations
                        = reader.readArray(reader1 -> CapacityReservationInstanceViewWithName.fromJson(reader1));
                    deserializedCapacityReservationGroupInstanceView.capacityReservations = capacityReservations;
                } else if ("sharedSubscriptionIds".equals(fieldName)) {
                    List<SubResourceReadOnly> sharedSubscriptionIds
                        = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    deserializedCapacityReservationGroupInstanceView.sharedSubscriptionIds = sharedSubscriptionIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapacityReservationGroupInstanceView;
        });
    }
}
