// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the data disk to be detached.
 */
@Fluent
public final class DataDisksToDetach implements JsonSerializable<DataDisksToDetach> {
    /*
     * ID of the managed data disk.
     */
    private String diskId;

    /*
     * Supported options available for Detach of a disk from a VM. Refer to DetachOption object reference for more
     * details.
     */
    private DiskDetachOptionTypes detachOption;

    /**
     * Creates an instance of DataDisksToDetach class.
     */
    public DataDisksToDetach() {
    }

    /**
     * Get the diskId property: ID of the managed data disk.
     * 
     * @return the diskId value.
     */
    public String diskId() {
        return this.diskId;
    }

    /**
     * Set the diskId property: ID of the managed data disk.
     * 
     * @param diskId the diskId value to set.
     * @return the DataDisksToDetach object itself.
     */
    public DataDisksToDetach withDiskId(String diskId) {
        this.diskId = diskId;
        return this;
    }

    /**
     * Get the detachOption property: Supported options available for Detach of a disk from a VM. Refer to DetachOption
     * object reference for more details.
     * 
     * @return the detachOption value.
     */
    public DiskDetachOptionTypes detachOption() {
        return this.detachOption;
    }

    /**
     * Set the detachOption property: Supported options available for Detach of a disk from a VM. Refer to DetachOption
     * object reference for more details.
     * 
     * @param detachOption the detachOption value to set.
     * @return the DataDisksToDetach object itself.
     */
    public DataDisksToDetach withDetachOption(DiskDetachOptionTypes detachOption) {
        this.detachOption = detachOption;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property diskId in model DataDisksToDetach"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataDisksToDetach.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskId", this.diskId);
        jsonWriter.writeStringField("detachOption", this.detachOption == null ? null : this.detachOption.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataDisksToDetach from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataDisksToDetach if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataDisksToDetach.
     */
    public static DataDisksToDetach fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataDisksToDetach deserializedDataDisksToDetach = new DataDisksToDetach();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskId".equals(fieldName)) {
                    deserializedDataDisksToDetach.diskId = reader.getString();
                } else if ("detachOption".equals(fieldName)) {
                    deserializedDataDisksToDetach.detachOption = DiskDetachOptionTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataDisksToDetach;
        });
    }
}
