// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration parameters used while performing a rolling upgrade.
 */
@Fluent
public final class RollingUpgradePolicy implements JsonSerializable<RollingUpgradePolicy> {
    /*
     * The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling
     * upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the
     * percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter
     * is 20%.
     */
    private Integer maxBatchInstancePercent;

    /*
     * The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously
     * unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine
     * health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     * default value for this parameter is 20%.
     */
    private Integer maxUnhealthyInstancePercent;

    /*
     * The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This
     * check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts.
     * The default value for this parameter is 20%.
     */
    private Integer maxUnhealthyUpgradedInstancePercent;

    /*
     * The wait time between completing the update for all virtual machines in one batch and starting the next batch.
     * The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
     */
    private String pauseTimeBetweenBatches;

    /*
     * Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the Update Domain
     * and maxBatchInstancePercent to determine the batch size.
     */
    private Boolean enableCrossZoneUpgrade;

    /*
     * Upgrade all unhealthy instances in a scale set before any healthy instances.
     */
    private Boolean prioritizeUnhealthyInstances;

    /*
     * Rollback failed instances to previous model if the Rolling Upgrade policy is violated.
     */
    private Boolean rollbackFailedInstancesOnPolicyBreach;

    /*
     * Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines.
     * Existing virtual machines will be deleted once the new virtual machines are created for each batch.
     */
    private Boolean maxSurge;

    /**
     * Creates an instance of RollingUpgradePolicy class.
     */
    public RollingUpgradePolicy() {
    }

    /**
     * Get the maxBatchInstancePercent property: The maximum percent of total virtual machine instances that will be
     * upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in
     * previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher
     * reliability. The default value for this parameter is 20%.
     * 
     * @return the maxBatchInstancePercent value.
     */
    public Integer maxBatchInstancePercent() {
        return this.maxBatchInstancePercent;
    }

    /**
     * Set the maxBatchInstancePercent property: The maximum percent of total virtual machine instances that will be
     * upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in
     * previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher
     * reliability. The default value for this parameter is 20%.
     * 
     * @param maxBatchInstancePercent the maxBatchInstancePercent value to set.
     * @return the RollingUpgradePolicy object itself.
     */
    public RollingUpgradePolicy withMaxBatchInstancePercent(Integer maxBatchInstancePercent) {
        this.maxBatchInstancePercent = maxBatchInstancePercent;
        return this;
    }

    /**
     * Get the maxUnhealthyInstancePercent property: The maximum percentage of the total virtual machine instances in
     * the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an
     * unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be
     * checked prior to starting any batch. The default value for this parameter is 20%.
     * 
     * @return the maxUnhealthyInstancePercent value.
     */
    public Integer maxUnhealthyInstancePercent() {
        return this.maxUnhealthyInstancePercent;
    }

    /**
     * Set the maxUnhealthyInstancePercent property: The maximum percentage of the total virtual machine instances in
     * the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an
     * unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be
     * checked prior to starting any batch. The default value for this parameter is 20%.
     * 
     * @param maxUnhealthyInstancePercent the maxUnhealthyInstancePercent value to set.
     * @return the RollingUpgradePolicy object itself.
     */
    public RollingUpgradePolicy withMaxUnhealthyInstancePercent(Integer maxUnhealthyInstancePercent) {
        this.maxUnhealthyInstancePercent = maxUnhealthyInstancePercent;
        return this;
    }

    /**
     * Get the maxUnhealthyUpgradedInstancePercent property: The maximum percentage of upgraded virtual machine
     * instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If
     * this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
     * 
     * @return the maxUnhealthyUpgradedInstancePercent value.
     */
    public Integer maxUnhealthyUpgradedInstancePercent() {
        return this.maxUnhealthyUpgradedInstancePercent;
    }

    /**
     * Set the maxUnhealthyUpgradedInstancePercent property: The maximum percentage of upgraded virtual machine
     * instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If
     * this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
     * 
     * @param maxUnhealthyUpgradedInstancePercent the maxUnhealthyUpgradedInstancePercent value to set.
     * @return the RollingUpgradePolicy object itself.
     */
    public RollingUpgradePolicy withMaxUnhealthyUpgradedInstancePercent(Integer maxUnhealthyUpgradedInstancePercent) {
        this.maxUnhealthyUpgradedInstancePercent = maxUnhealthyUpgradedInstancePercent;
        return this;
    }

    /**
     * Get the pauseTimeBetweenBatches property: The wait time between completing the update for all virtual machines in
     * one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default
     * value is 0 seconds (PT0S).
     * 
     * @return the pauseTimeBetweenBatches value.
     */
    public String pauseTimeBetweenBatches() {
        return this.pauseTimeBetweenBatches;
    }

    /**
     * Set the pauseTimeBetweenBatches property: The wait time between completing the update for all virtual machines in
     * one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default
     * value is 0 seconds (PT0S).
     * 
     * @param pauseTimeBetweenBatches the pauseTimeBetweenBatches value to set.
     * @return the RollingUpgradePolicy object itself.
     */
    public RollingUpgradePolicy withPauseTimeBetweenBatches(String pauseTimeBetweenBatches) {
        this.pauseTimeBetweenBatches = pauseTimeBetweenBatches;
        return this;
    }

    /**
     * Get the enableCrossZoneUpgrade property: Allow VMSS to ignore AZ boundaries when constructing upgrade batches.
     * Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
     * 
     * @return the enableCrossZoneUpgrade value.
     */
    public Boolean enableCrossZoneUpgrade() {
        return this.enableCrossZoneUpgrade;
    }

    /**
     * Set the enableCrossZoneUpgrade property: Allow VMSS to ignore AZ boundaries when constructing upgrade batches.
     * Take into consideration the Update Domain and maxBatchInstancePercent to determine the batch size.
     * 
     * @param enableCrossZoneUpgrade the enableCrossZoneUpgrade value to set.
     * @return the RollingUpgradePolicy object itself.
     */
    public RollingUpgradePolicy withEnableCrossZoneUpgrade(Boolean enableCrossZoneUpgrade) {
        this.enableCrossZoneUpgrade = enableCrossZoneUpgrade;
        return this;
    }

    /**
     * Get the prioritizeUnhealthyInstances property: Upgrade all unhealthy instances in a scale set before any healthy
     * instances.
     * 
     * @return the prioritizeUnhealthyInstances value.
     */
    public Boolean prioritizeUnhealthyInstances() {
        return this.prioritizeUnhealthyInstances;
    }

    /**
     * Set the prioritizeUnhealthyInstances property: Upgrade all unhealthy instances in a scale set before any healthy
     * instances.
     * 
     * @param prioritizeUnhealthyInstances the prioritizeUnhealthyInstances value to set.
     * @return the RollingUpgradePolicy object itself.
     */
    public RollingUpgradePolicy withPrioritizeUnhealthyInstances(Boolean prioritizeUnhealthyInstances) {
        this.prioritizeUnhealthyInstances = prioritizeUnhealthyInstances;
        return this;
    }

    /**
     * Get the rollbackFailedInstancesOnPolicyBreach property: Rollback failed instances to previous model if the
     * Rolling Upgrade policy is violated.
     * 
     * @return the rollbackFailedInstancesOnPolicyBreach value.
     */
    public Boolean rollbackFailedInstancesOnPolicyBreach() {
        return this.rollbackFailedInstancesOnPolicyBreach;
    }

    /**
     * Set the rollbackFailedInstancesOnPolicyBreach property: Rollback failed instances to previous model if the
     * Rolling Upgrade policy is violated.
     * 
     * @param rollbackFailedInstancesOnPolicyBreach the rollbackFailedInstancesOnPolicyBreach value to set.
     * @return the RollingUpgradePolicy object itself.
     */
    public RollingUpgradePolicy
        withRollbackFailedInstancesOnPolicyBreach(Boolean rollbackFailedInstancesOnPolicyBreach) {
        this.rollbackFailedInstancesOnPolicyBreach = rollbackFailedInstancesOnPolicyBreach;
        return this;
    }

    /**
     * Get the maxSurge property: Create new virtual machines to upgrade the scale set, rather than updating the
     * existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created
     * for each batch.
     * 
     * @return the maxSurge value.
     */
    public Boolean maxSurge() {
        return this.maxSurge;
    }

    /**
     * Set the maxSurge property: Create new virtual machines to upgrade the scale set, rather than updating the
     * existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created
     * for each batch.
     * 
     * @param maxSurge the maxSurge value to set.
     * @return the RollingUpgradePolicy object itself.
     */
    public RollingUpgradePolicy withMaxSurge(Boolean maxSurge) {
        this.maxSurge = maxSurge;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxBatchInstancePercent", this.maxBatchInstancePercent);
        jsonWriter.writeNumberField("maxUnhealthyInstancePercent", this.maxUnhealthyInstancePercent);
        jsonWriter.writeNumberField("maxUnhealthyUpgradedInstancePercent", this.maxUnhealthyUpgradedInstancePercent);
        jsonWriter.writeStringField("pauseTimeBetweenBatches", this.pauseTimeBetweenBatches);
        jsonWriter.writeBooleanField("enableCrossZoneUpgrade", this.enableCrossZoneUpgrade);
        jsonWriter.writeBooleanField("prioritizeUnhealthyInstances", this.prioritizeUnhealthyInstances);
        jsonWriter.writeBooleanField("rollbackFailedInstancesOnPolicyBreach",
            this.rollbackFailedInstancesOnPolicyBreach);
        jsonWriter.writeBooleanField("maxSurge", this.maxSurge);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RollingUpgradePolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RollingUpgradePolicy if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RollingUpgradePolicy.
     */
    public static RollingUpgradePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RollingUpgradePolicy deserializedRollingUpgradePolicy = new RollingUpgradePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxBatchInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxBatchInstancePercent = reader.getNullable(JsonReader::getInt);
                } else if ("maxUnhealthyInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxUnhealthyInstancePercent
                        = reader.getNullable(JsonReader::getInt);
                } else if ("maxUnhealthyUpgradedInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxUnhealthyUpgradedInstancePercent
                        = reader.getNullable(JsonReader::getInt);
                } else if ("pauseTimeBetweenBatches".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.pauseTimeBetweenBatches = reader.getString();
                } else if ("enableCrossZoneUpgrade".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.enableCrossZoneUpgrade
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("prioritizeUnhealthyInstances".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.prioritizeUnhealthyInstances
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("rollbackFailedInstancesOnPolicyBreach".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.rollbackFailedInstancesOnPolicyBreach
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("maxSurge".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxSurge = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRollingUpgradePolicy;
        });
    }
}
