// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a virtual machine scale set VM network profile.
 */
@Fluent
public final class VirtualMachineScaleSetVMNetworkProfileConfiguration
    implements JsonSerializable<VirtualMachineScaleSetVMNetworkProfileConfiguration> {
    /*
     * The list of network configurations.
     */
    private List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations;

    /**
     * Creates an instance of VirtualMachineScaleSetVMNetworkProfileConfiguration class.
     */
    public VirtualMachineScaleSetVMNetworkProfileConfiguration() {
    }

    /**
     * Get the networkInterfaceConfigurations property: The list of network configurations.
     * 
     * @return the networkInterfaceConfigurations value.
     */
    public List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations() {
        return this.networkInterfaceConfigurations;
    }

    /**
     * Set the networkInterfaceConfigurations property: The list of network configurations.
     * 
     * @param networkInterfaceConfigurations the networkInterfaceConfigurations value to set.
     * @return the VirtualMachineScaleSetVMNetworkProfileConfiguration object itself.
     */
    public VirtualMachineScaleSetVMNetworkProfileConfiguration withNetworkInterfaceConfigurations(
        List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations) {
        this.networkInterfaceConfigurations = networkInterfaceConfigurations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkInterfaceConfigurations() != null) {
            networkInterfaceConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("networkInterfaceConfigurations", this.networkInterfaceConfigurations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetVMNetworkProfileConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetVMNetworkProfileConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetVMNetworkProfileConfiguration.
     */
    public static VirtualMachineScaleSetVMNetworkProfileConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMNetworkProfileConfiguration deserializedVirtualMachineScaleSetVMNetworkProfileConfiguration
                = new VirtualMachineScaleSetVMNetworkProfileConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkInterfaceConfigurations".equals(fieldName)) {
                    List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations
                        = reader.readArray(reader1 -> VirtualMachineScaleSetNetworkConfiguration.fromJson(reader1));
                    deserializedVirtualMachineScaleSetVMNetworkProfileConfiguration.networkInterfaceConfigurations
                        = networkInterfaceConfigurations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetVMNetworkProfileConfiguration;
        });
    }
}
