// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.compute.fluent.models.DiskRestorePointInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DiskRestorePointsClient. */
public interface DiskRestorePointsClient {
    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DiskRestorePointInner>> getWithResponseAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName);

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DiskRestorePointInner> getAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName);

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DiskRestorePointInner get(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName);

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DiskRestorePointInner> getWithResponse(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName,
        Context context);

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DiskRestorePointInner> listByRestorePointAsync(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName);

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DiskRestorePointInner> listByRestorePoint(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName);

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DiskRestorePointInner> listByRestorePoint(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, Context context);
}
