// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.GalleryInner;
import com.azure.resourcemanager.compute.models.GalleryUpdate;
import com.azure.resourcemanager.compute.models.SelectPermissions;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GalleriesClient. */
public interface GalleriesClient
    extends InnerSupportsGet<GalleryInner>, InnerSupportsListing<GalleryInner>, InnerSupportsDelete<Void> {
    /**
     * Create or update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the create or update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String galleryName, GalleryInner gallery);

    /**
     * Create or update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the create or update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<GalleryInner>, GalleryInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String galleryName, GalleryInner gallery);

    /**
     * Create or update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the create or update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<GalleryInner>, GalleryInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, GalleryInner gallery);

    /**
     * Create or update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the create or update Shared Image Gallery operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<GalleryInner>, GalleryInner> beginCreateOrUpdate(
        String resourceGroupName, String galleryName, GalleryInner gallery, Context context);

    /**
     * Create or update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the create or update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInner> createOrUpdateAsync(String resourceGroupName, String galleryName, GalleryInner gallery);

    /**
     * Create or update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the create or update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInner createOrUpdate(String resourceGroupName, String galleryName, GalleryInner gallery);

    /**
     * Create or update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the create or update Shared Image Gallery operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInner createOrUpdate(String resourceGroupName, String galleryName, GalleryInner gallery, Context context);

    /**
     * Update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName, String galleryName, GalleryUpdate gallery);

    /**
     * Update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<GalleryInner>, GalleryInner> beginUpdateAsync(
        String resourceGroupName, String galleryName, GalleryUpdate gallery);

    /**
     * Update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<GalleryInner>, GalleryInner> beginUpdate(
        String resourceGroupName, String galleryName, GalleryUpdate gallery);

    /**
     * Update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the update Shared Image Gallery operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<GalleryInner>, GalleryInner> beginUpdate(
        String resourceGroupName, String galleryName, GalleryUpdate gallery, Context context);

    /**
     * Update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInner> updateAsync(String resourceGroupName, String galleryName, GalleryUpdate gallery);

    /**
     * Update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the update Shared Image Gallery operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInner update(String resourceGroupName, String galleryName, GalleryUpdate gallery);

    /**
     * Update a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with
     *     dots and periods allowed in the middle. The maximum length is 80 characters.
     * @param gallery Parameters supplied to the update Shared Image Gallery operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInner update(String resourceGroupName, String galleryName, GalleryUpdate gallery, Context context);

    /**
     * Retrieves information about a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery.
     * @param select The select expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<GalleryInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String galleryName, SelectPermissions select);

    /**
     * Retrieves information about a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery.
     * @param select The select expression to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInner> getByResourceGroupAsync(String resourceGroupName, String galleryName, SelectPermissions select);

    /**
     * Retrieves information about a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInner> getByResourceGroupAsync(String resourceGroupName, String galleryName);

    /**
     * Retrieves information about a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInner getByResourceGroup(String resourceGroupName, String galleryName);

    /**
     * Retrieves information about a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery.
     * @param select The select expression to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the Shared Image Gallery that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GalleryInner> getByResourceGroupWithResponse(
        String resourceGroupName, String galleryName, SelectPermissions select, Context context);

    /**
     * Delete a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName);

    /**
     * Delete a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName);

    /**
     * Delete a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName);

    /**
     * Delete a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, Context context);

    /**
     * Delete a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String galleryName);

    /**
     * Delete a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName);

    /**
     * Delete a Shared Image Gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, Context context);

    /**
     * List galleries under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Galleries operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<GalleryInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * List galleries under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Galleries operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryInner> listByResourceGroup(String resourceGroupName);

    /**
     * List galleries under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Galleries operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * List galleries under a subscription.
     *
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Galleries operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<GalleryInner> listAsync();

    /**
     * List galleries under a subscription.
     *
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Galleries operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryInner> list();

    /**
     * List galleries under a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Galleries operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryInner> list(Context context);
}
