// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.GalleryApplicationInner;
import com.azure.resourcemanager.compute.models.GalleryApplicationUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GalleryApplicationsClient. */
public interface GalleryApplicationsClient {
    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The
     *     allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     *     maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationInner galleryApplication);

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The
     *     allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     *     maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<GalleryApplicationInner>, GalleryApplicationInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationInner galleryApplication);

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The
     *     allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     *     maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<GalleryApplicationInner>, GalleryApplicationInner> beginCreateOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationInner galleryApplication);

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The
     *     allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     *     maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<GalleryApplicationInner>, GalleryApplicationInner> beginCreateOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationInner galleryApplication,
        Context context);

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The
     *     allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     *     maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryApplicationInner> createOrUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationInner galleryApplication);

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The
     *     allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     *     maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryApplicationInner createOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationInner galleryApplication);

    /**
     * Create or update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     created.
     * @param galleryApplicationName The name of the gallery Application Definition to be created or updated. The
     *     allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     *     maximum length is 80 characters.
     * @param galleryApplication Parameters supplied to the create or update gallery Application operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryApplicationInner createOrUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationInner galleryApplication,
        Context context);

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed
     *     characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length
     *     is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationUpdate galleryApplication);

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed
     *     characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length
     *     is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<GalleryApplicationInner>, GalleryApplicationInner> beginUpdateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationUpdate galleryApplication);

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed
     *     characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length
     *     is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<GalleryApplicationInner>, GalleryApplicationInner> beginUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationUpdate galleryApplication);

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed
     *     characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length
     *     is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<GalleryApplicationInner>, GalleryApplicationInner> beginUpdate(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationUpdate galleryApplication,
        Context context);

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed
     *     characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length
     *     is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryApplicationInner> updateAsync(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationUpdate galleryApplication);

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed
     *     characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length
     *     is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryApplicationInner update(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationUpdate galleryApplication);

    /**
     * Update a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     updated.
     * @param galleryApplicationName The name of the gallery Application Definition to be updated. The allowed
     *     characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length
     *     is 80 characters.
     * @param galleryApplication Parameters supplied to the update gallery Application operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryApplicationInner update(
        String resourceGroupName,
        String galleryName,
        String galleryApplicationName,
        GalleryApplicationUpdate galleryApplication,
        Context context);

    /**
     * Retrieves information about a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be
     *     retrieved.
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<GalleryApplicationInner>> getWithResponseAsync(
        String resourceGroupName, String galleryName, String galleryApplicationName);

    /**
     * Retrieves information about a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be
     *     retrieved.
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryApplicationInner> getAsync(String resourceGroupName, String galleryName, String galleryApplicationName);

    /**
     * Retrieves information about a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be
     *     retrieved.
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryApplicationInner get(String resourceGroupName, String galleryName, String galleryApplicationName);

    /**
     * Retrieves information about a gallery Application Definition.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which the Application Definitions are to be
     *     retrieved.
     * @param galleryApplicationName The name of the gallery Application Definition to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery Application Definition that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GalleryApplicationInner> getWithResponse(
        String resourceGroupName, String galleryName, String galleryApplicationName, Context context);

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String galleryName, String galleryApplicationName);

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String galleryName, String galleryApplicationName);

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String galleryName, String galleryApplicationName);

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String galleryName, String galleryApplicationName, Context context);

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryApplicationName);

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String galleryApplicationName);

    /**
     * Delete a gallery Application.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery in which the Application Definition is to be
     *     deleted.
     * @param galleryApplicationName The name of the gallery Application Definition to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String galleryApplicationName, Context context);

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which Application Definitions are to be
     *     listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Applications operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<GalleryApplicationInner> listByGalleryAsync(String resourceGroupName, String galleryName);

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which Application Definitions are to be
     *     listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Applications operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryApplicationInner> listByGallery(String resourceGroupName, String galleryName);

    /**
     * List gallery Application Definitions in a gallery.
     *
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Application Gallery from which Application Definitions are to be
     *     listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery Applications operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryApplicationInner> listByGallery(String resourceGroupName, String galleryName, Context context);
}
