// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CloudServiceProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Describes the cloud service. */
@Fluent
public final class CloudServiceInner extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CloudServiceInner.class);

    /*
     * Cloud service properties
     */
    @JsonProperty(value = "properties")
    private CloudServiceProperties properties;

    /**
     * Get the properties property: Cloud service properties.
     *
     * @return the properties value.
     */
    public CloudServiceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Cloud service properties.
     *
     * @param properties the properties value to set.
     * @return the CloudServiceInner object itself.
     */
    public CloudServiceInner withProperties(CloudServiceProperties properties) {
        this.properties = properties;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CloudServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CloudServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
