// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.ProxyOnlyResource;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Properties of disk restore point. */
@JsonFlatten
@Fluent
public class DiskRestorePointInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DiskRestorePointInner.class);

    /*
     * The timestamp of restorePoint creation
     */
    @JsonProperty(value = "properties.timeCreated", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;

    /*
     * arm id of source disk
     */
    @JsonProperty(value = "properties.sourceResourceId", access = JsonProperty.Access.WRITE_ONLY)
    private String sourceResourceId;

    /*
     * The Operating System type.
     */
    @JsonProperty(value = "properties.osType", access = JsonProperty.Access.WRITE_ONLY)
    private OperatingSystemTypes osType;

    /*
     * The hypervisor generation of the Virtual Machine. Applicable to OS disks
     * only.
     */
    @JsonProperty(value = "properties.hyperVGeneration")
    private HyperVGeneration hyperVGeneration;

    /*
     * Purchase plan information for the the image from which the OS disk was
     * created.
     */
    @JsonProperty(value = "properties.purchasePlan")
    private PurchasePlanAutoGenerated purchasePlan;

    /*
     * id of the backing snapshot's MIS family
     */
    @JsonProperty(value = "properties.familyId", access = JsonProperty.Access.WRITE_ONLY)
    private String familyId;

    /*
     * unique incarnation id of the source disk
     */
    @JsonProperty(value = "properties.sourceUniqueId", access = JsonProperty.Access.WRITE_ONLY)
    private String sourceUniqueId;

    /*
     * Encryption property can be used to encrypt data at rest with customer
     * managed keys or platform managed keys.
     */
    @JsonProperty(value = "properties.encryption", access = JsonProperty.Access.WRITE_ONLY)
    private Encryption encryption;

    /*
     * Indicates the OS on a disk supports hibernation.
     */
    @JsonProperty(value = "properties.supportsHibernation")
    private Boolean supportsHibernation;

    /**
     * Get the timeCreated property: The timestamp of restorePoint creation.
     *
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Get the sourceResourceId property: arm id of source disk.
     *
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    /**
     * Get the osType property: The Operating System type.
     *
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Get the hyperVGeneration property: The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     *
     * @return the hyperVGeneration value.
     */
    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    /**
     * Set the hyperVGeneration property: The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     *
     * @param hyperVGeneration the hyperVGeneration value to set.
     * @return the DiskRestorePointInner object itself.
     */
    public DiskRestorePointInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    /**
     * Get the purchasePlan property: Purchase plan information for the the image from which the OS disk was created.
     *
     * @return the purchasePlan value.
     */
    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    /**
     * Set the purchasePlan property: Purchase plan information for the the image from which the OS disk was created.
     *
     * @param purchasePlan the purchasePlan value to set.
     * @return the DiskRestorePointInner object itself.
     */
    public DiskRestorePointInner withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    /**
     * Get the familyId property: id of the backing snapshot's MIS family.
     *
     * @return the familyId value.
     */
    public String familyId() {
        return this.familyId;
    }

    /**
     * Get the sourceUniqueId property: unique incarnation id of the source disk.
     *
     * @return the sourceUniqueId value.
     */
    public String sourceUniqueId() {
        return this.sourceUniqueId;
    }

    /**
     * Get the encryption property: Encryption property can be used to encrypt data at rest with customer managed keys
     * or platform managed keys.
     *
     * @return the encryption value.
     */
    public Encryption encryption() {
        return this.encryption;
    }

    /**
     * Get the supportsHibernation property: Indicates the OS on a disk supports hibernation.
     *
     * @return the supportsHibernation value.
     */
    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    /**
     * Set the supportsHibernation property: Indicates the OS on a disk supports hibernation.
     *
     * @param supportsHibernation the supportsHibernation value to set.
     * @return the DiskRestorePointInner object itself.
     */
    public DiskRestorePointInner withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (purchasePlan() != null) {
            purchasePlan().validate();
        }
        if (encryption() != null) {
            encryption().validate();
        }
    }
}
