// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.CloudServicesUpdateDomainsClient;
import com.azure.resourcemanager.compute.fluent.models.UpdateDomainInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.UpdateDomainListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in CloudServicesUpdateDomainsClient. */
public final class CloudServicesUpdateDomainsClientImpl implements CloudServicesUpdateDomainsClient {
    private final ClientLogger logger = new ClientLogger(CloudServicesUpdateDomainsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final CloudServicesUpdateDomainsService service;

    /** The service client containing this operation class. */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of CloudServicesUpdateDomainsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    CloudServicesUpdateDomainsClientImpl(ComputeManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    CloudServicesUpdateDomainsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientCloudServicesUpdateDomains to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    private interface CloudServicesUpdateDomainsService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/updateDomains/{updateDomain}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> walkUpdateDomain(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("updateDomain") int updateDomain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") UpdateDomainInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/updateDomains/{updateDomain}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<UpdateDomainInner>> getUpdateDomain(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("updateDomain") int updateDomain,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/updateDomains")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<UpdateDomainListResult>> listUpdateDomains(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<UpdateDomainListResult>> listUpdateDomainsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> walkUpdateDomainWithResponseAsync(
        String resourceGroupName, String cloudServiceName, int updateDomain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .walkUpdateDomain(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            cloudServiceName,
                            updateDomain,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            null,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> walkUpdateDomainWithResponseAsync(
        String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .walkUpdateDomain(
                this.client.getEndpoint(),
                resourceGroupName,
                cloudServiceName,
                updateDomain,
                this.client.getSubscriptionId(),
                apiVersion,
                null,
                accept,
                context);
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginWalkUpdateDomainAsync(
        String resourceGroupName, String cloudServiceName, int updateDomain) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            walkUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginWalkUpdateDomainAsync(
        String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            walkUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginWalkUpdateDomain(
        String resourceGroupName, String cloudServiceName, int updateDomain) {
        return beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain).getSyncPoller();
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginWalkUpdateDomain(
        String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        return beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, context).getSyncPoller();
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> walkUpdateDomainAsync(String resourceGroupName, String cloudServiceName, int updateDomain) {
        return beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> walkUpdateDomainAsync(
        String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        return beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void walkUpdateDomain(String resourceGroupName, String cloudServiceName, int updateDomain) {
        walkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain).block();
    }

    /**
     * Updates the role instances in the specified update domain.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void walkUpdateDomain(String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        walkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, context).block();
    }

    /**
     * Gets the specified update domain of a cloud service. Use nextLink property in the response to get the next page
     * of update domains. Do this till nextLink is null to fetch all the update domains.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified update domain of a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<UpdateDomainInner>> getUpdateDomainWithResponseAsync(
        String resourceGroupName, String cloudServiceName, int updateDomain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getUpdateDomain(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            cloudServiceName,
                            updateDomain,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified update domain of a cloud service. Use nextLink property in the response to get the next page
     * of update domains. Do this till nextLink is null to fetch all the update domains.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified update domain of a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<UpdateDomainInner>> getUpdateDomainWithResponseAsync(
        String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getUpdateDomain(
                this.client.getEndpoint(),
                resourceGroupName,
                cloudServiceName,
                updateDomain,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * Gets the specified update domain of a cloud service. Use nextLink property in the response to get the next page
     * of update domains. Do this till nextLink is null to fetch all the update domains.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified update domain of a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<UpdateDomainInner> getUpdateDomainAsync(
        String resourceGroupName, String cloudServiceName, int updateDomain) {
        return getUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain)
            .flatMap(
                (Response<UpdateDomainInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the specified update domain of a cloud service. Use nextLink property in the response to get the next page
     * of update domains. Do this till nextLink is null to fetch all the update domains.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified update domain of a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public UpdateDomainInner getUpdateDomain(String resourceGroupName, String cloudServiceName, int updateDomain) {
        return getUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain).block();
    }

    /**
     * Gets the specified update domain of a cloud service. Use nextLink property in the response to get the next page
     * of update domains. Do this till nextLink is null to fetch all the update domains.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param updateDomain Specifies an integer value that identifies the update domain. Update domains are identified
     *     with a zero-based index: the first update domain has an ID of 0, the second has an ID of 1, and so on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified update domain of a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<UpdateDomainInner> getUpdateDomainWithResponse(
        String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        return getUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain, context).block();
    }

    /**
     * Gets a list of all update domains in a cloud service.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all update domains in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<UpdateDomainInner>> listUpdateDomainsSinglePageAsync(
        String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listUpdateDomains(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<UpdateDomainInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of all update domains in a cloud service.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all update domains in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<UpdateDomainInner>> listUpdateDomainsSinglePageAsync(
        String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listUpdateDomains(
                this.client.getEndpoint(),
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets a list of all update domains in a cloud service.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all update domains in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<UpdateDomainInner> listUpdateDomainsAsync(String resourceGroupName, String cloudServiceName) {
        return new PagedFlux<>(
            () -> listUpdateDomainsSinglePageAsync(resourceGroupName, cloudServiceName),
            nextLink -> listUpdateDomainsNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of all update domains in a cloud service.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all update domains in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<UpdateDomainInner> listUpdateDomainsAsync(
        String resourceGroupName, String cloudServiceName, Context context) {
        return new PagedFlux<>(
            () -> listUpdateDomainsSinglePageAsync(resourceGroupName, cloudServiceName, context),
            nextLink -> listUpdateDomainsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of all update domains in a cloud service.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all update domains in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<UpdateDomainInner> listUpdateDomains(String resourceGroupName, String cloudServiceName) {
        return new PagedIterable<>(listUpdateDomainsAsync(resourceGroupName, cloudServiceName));
    }

    /**
     * Gets a list of all update domains in a cloud service.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all update domains in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<UpdateDomainInner> listUpdateDomains(
        String resourceGroupName, String cloudServiceName, Context context) {
        return new PagedIterable<>(listUpdateDomainsAsync(resourceGroupName, cloudServiceName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<UpdateDomainInner>> listUpdateDomainsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listUpdateDomainsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<UpdateDomainInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<UpdateDomainInner>> listUpdateDomainsNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listUpdateDomainsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
