// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.DiskEncryptionSetsClient;
import com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetList;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetUpdate;
import com.azure.resourcemanager.compute.models.ResourceUriList;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DiskEncryptionSetsClient. */
public final class DiskEncryptionSetsClientImpl
    implements InnerSupportsGet<DiskEncryptionSetInner>,
        InnerSupportsListing<DiskEncryptionSetInner>,
        InnerSupportsDelete<Void>,
        DiskEncryptionSetsClient {
    private final ClientLogger logger = new ClientLogger(DiskEncryptionSetsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DiskEncryptionSetsService service;

    /** The service client containing this operation class. */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DiskEncryptionSetsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DiskEncryptionSetsClientImpl(ComputeManagementClientImpl client) {
        this.service =
            RestProxy.create(DiskEncryptionSetsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientDiskEncryptionSets to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    private interface DiskEncryptionSetsService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/diskEncryptionSets/{diskEncryptionSetName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskEncryptionSetName") String diskEncryptionSetName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DiskEncryptionSetInner diskEncryptionSet,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/diskEncryptionSets/{diskEncryptionSetName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskEncryptionSetName") String diskEncryptionSetName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DiskEncryptionSetUpdate diskEncryptionSet,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/diskEncryptionSets/{diskEncryptionSetName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskEncryptionSetInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskEncryptionSetName") String diskEncryptionSetName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/diskEncryptionSets/{diskEncryptionSetName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskEncryptionSetName") String diskEncryptionSetName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/diskEncryptionSets")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskEncryptionSetList>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/diskEncryptionSets")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskEncryptionSetList>> list(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/diskEncryptionSets/{diskEncryptionSetName}/associatedResources")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<ResourceUriList>> listAssociatedResources(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("diskEncryptionSetName") String diskEncryptionSetName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskEncryptionSetList>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskEncryptionSetList>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<ResourceUriList>> listAssociatedResourcesNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        if (diskEncryptionSet == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null."));
        } else {
            diskEncryptionSet.validate();
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            diskEncryptionSetName,
                            apiVersion,
                            diskEncryptionSet,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetInner diskEncryptionSet,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        if (diskEncryptionSet == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null."));
        } else {
            diskEncryptionSet.validate();
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                diskEncryptionSetName,
                apiVersion,
                diskEncryptionSet,
                accept,
                context);
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<DiskEncryptionSetInner>, DiskEncryptionSetInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet);
        return this
            .client
            .<DiskEncryptionSetInner, DiskEncryptionSetInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                DiskEncryptionSetInner.class,
                DiskEncryptionSetInner.class,
                Context.NONE);
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<DiskEncryptionSetInner>, DiskEncryptionSetInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetInner diskEncryptionSet,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet, context);
        return this
            .client
            .<DiskEncryptionSetInner, DiskEncryptionSetInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                DiskEncryptionSetInner.class,
                DiskEncryptionSetInner.class,
                context);
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<DiskEncryptionSetInner>, DiskEncryptionSetInner> beginCreateOrUpdate(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return beginCreateOrUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).getSyncPoller();
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<DiskEncryptionSetInner>, DiskEncryptionSetInner> beginCreateOrUpdate(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetInner diskEncryptionSet,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet, context)
            .getSyncPoller();
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiskEncryptionSetInner> createOrUpdateAsync(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return beginCreateOrUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DiskEncryptionSetInner> createOrUpdateAsync(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetInner diskEncryptionSet,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskEncryptionSetInner createOrUpdate(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetInner diskEncryptionSet) {
        return createOrUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).block();
    }

    /**
     * Creates or updates a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Put disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskEncryptionSetInner createOrUpdate(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetInner diskEncryptionSet,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet, context).block();
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        if (diskEncryptionSet == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null."));
        } else {
            diskEncryptionSet.validate();
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            diskEncryptionSetName,
                            apiVersion,
                            diskEncryptionSet,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetUpdate diskEncryptionSet,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        if (diskEncryptionSet == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSet is required and cannot be null."));
        } else {
            diskEncryptionSet.validate();
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                diskEncryptionSetName,
                apiVersion,
                diskEncryptionSet,
                accept,
                context);
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<DiskEncryptionSetInner>, DiskEncryptionSetInner> beginUpdateAsync(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet);
        return this
            .client
            .<DiskEncryptionSetInner, DiskEncryptionSetInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                DiskEncryptionSetInner.class,
                DiskEncryptionSetInner.class,
                Context.NONE);
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<DiskEncryptionSetInner>, DiskEncryptionSetInner> beginUpdateAsync(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetUpdate diskEncryptionSet,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet, context);
        return this
            .client
            .<DiskEncryptionSetInner, DiskEncryptionSetInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                DiskEncryptionSetInner.class,
                DiskEncryptionSetInner.class,
                context);
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<DiskEncryptionSetInner>, DiskEncryptionSetInner> beginUpdate(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return beginUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).getSyncPoller();
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<DiskEncryptionSetInner>, DiskEncryptionSetInner> beginUpdate(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetUpdate diskEncryptionSet,
        Context context) {
        return beginUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet, context).getSyncPoller();
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiskEncryptionSetInner> updateAsync(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return beginUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DiskEncryptionSetInner> updateAsync(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetUpdate diskEncryptionSet,
        Context context) {
        return beginUpdateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskEncryptionSetInner update(
        String resourceGroupName, String diskEncryptionSetName, DiskEncryptionSetUpdate diskEncryptionSet) {
        return updateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet).block();
    }

    /**
     * Updates (patches) a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param diskEncryptionSet disk encryption set object supplied in the body of the Patch disk encryption set
     *     operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk encryption set resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskEncryptionSetInner update(
        String resourceGroupName,
        String diskEncryptionSetName,
        DiskEncryptionSetUpdate diskEncryptionSet,
        Context context) {
        return updateAsync(resourceGroupName, diskEncryptionSetName, diskEncryptionSet, context).block();
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiskEncryptionSetInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            diskEncryptionSetName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiskEncryptionSetInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String diskEncryptionSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                diskEncryptionSetName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiskEncryptionSetInner> getByResourceGroupAsync(
        String resourceGroupName, String diskEncryptionSetName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, diskEncryptionSetName)
            .flatMap(
                (Response<DiskEncryptionSetInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskEncryptionSetInner getByResourceGroup(String resourceGroupName, String diskEncryptionSetName) {
        return getByResourceGroupAsync(resourceGroupName, diskEncryptionSetName).block();
    }

    /**
     * Gets information about a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiskEncryptionSetInner> getByResourceGroupWithResponse(
        String resourceGroupName, String diskEncryptionSetName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, diskEncryptionSetName, context).block();
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            diskEncryptionSetName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String diskEncryptionSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                diskEncryptionSetName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String diskEncryptionSetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, diskEncryptionSetName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String diskEncryptionSetName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, diskEncryptionSetName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String diskEncryptionSetName) {
        return beginDeleteAsync(resourceGroupName, diskEncryptionSetName).getSyncPoller();
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String diskEncryptionSetName, Context context) {
        return beginDeleteAsync(resourceGroupName, diskEncryptionSetName, context).getSyncPoller();
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String diskEncryptionSetName) {
        return beginDeleteAsync(resourceGroupName, diskEncryptionSetName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String diskEncryptionSetName, Context context) {
        return beginDeleteAsync(resourceGroupName, diskEncryptionSetName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String diskEncryptionSetName) {
        deleteAsync(resourceGroupName, diskEncryptionSetName).block();
    }

    /**
     * Deletes a disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String diskEncryptionSetName, Context context) {
        deleteAsync(resourceGroupName, diskEncryptionSetName, context).block();
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskEncryptionSetInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<DiskEncryptionSetInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskEncryptionSetInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DiskEncryptionSetInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiskEncryptionSetInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskEncryptionSetInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Lists all the disk encryption sets under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskEncryptionSetInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskEncryptionSetInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, accept, context))
            .<PagedResponse<DiskEncryptionSetInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskEncryptionSetInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DiskEncryptionSetInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiskEncryptionSetInner> listAsync(Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskEncryptionSetInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Lists all the disk encryption sets under a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskEncryptionSetInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List resources which are encrypted with the disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listAssociatedResourcesSinglePageAsync(
        String resourceGroupName, String diskEncryptionSetName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listAssociatedResources(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            diskEncryptionSetName,
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List resources which are encrypted with the disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listAssociatedResourcesSinglePageAsync(
        String resourceGroupName, String diskEncryptionSetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (diskEncryptionSetName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskEncryptionSetName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAssociatedResources(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                diskEncryptionSetName,
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List resources which are encrypted with the disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listAssociatedResourcesAsync(String resourceGroupName, String diskEncryptionSetName) {
        return new PagedFlux<>(
            () -> listAssociatedResourcesSinglePageAsync(resourceGroupName, diskEncryptionSetName),
            nextLink -> listAssociatedResourcesNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List resources which are encrypted with the disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listAssociatedResourcesAsync(
        String resourceGroupName, String diskEncryptionSetName, Context context) {
        return new PagedFlux<>(
            () -> listAssociatedResourcesSinglePageAsync(resourceGroupName, diskEncryptionSetName, context),
            nextLink -> listAssociatedResourcesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List resources which are encrypted with the disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listAssociatedResources(String resourceGroupName, String diskEncryptionSetName) {
        return new PagedIterable<>(listAssociatedResourcesAsync(resourceGroupName, diskEncryptionSetName));
    }

    /**
     * Lists all resources that are encrypted with this disk encryption set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param diskEncryptionSetName The name of the disk encryption set that is being created. The name can't be changed
     *     after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
     *     maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List resources which are encrypted with the disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listAssociatedResources(
        String resourceGroupName, String diskEncryptionSetName, Context context) {
        return new PagedIterable<>(listAssociatedResourcesAsync(resourceGroupName, diskEncryptionSetName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskEncryptionSetInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DiskEncryptionSetInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskEncryptionSetInner>> listByResourceGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskEncryptionSetInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DiskEncryptionSetInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List disk encryption set operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskEncryptionSetInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List resources which are encrypted with the disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listAssociatedResourcesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listAssociatedResourcesNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List resources which are encrypted with the disk encryption set.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listAssociatedResourcesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAssociatedResourcesNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
