// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.DiskRestorePointsClient;
import com.azure.resourcemanager.compute.fluent.models.DiskRestorePointInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.DiskRestorePointList;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DiskRestorePointsClient. */
public final class DiskRestorePointsClientImpl implements DiskRestorePointsClient {
    private final ClientLogger logger = new ClientLogger(DiskRestorePointsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DiskRestorePointsService service;

    /** The service client containing this operation class. */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of DiskRestorePointsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DiskRestorePointsClientImpl(ComputeManagementClientImpl client) {
        this.service =
            RestProxy.create(DiskRestorePointsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientDiskRestorePoints to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    private interface DiskRestorePointsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}"
                + "/diskRestorePoints/{diskRestorePointName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskRestorePointInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("restorePointCollectionName") String restorePointCollectionName,
            @PathParam("vmRestorePointName") String vmRestorePointName,
            @PathParam("diskRestorePointName") String diskRestorePointName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}"
                + "/diskRestorePoints")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskRestorePointList>> listByRestorePoint(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("restorePointCollectionName") String restorePointCollectionName,
            @PathParam("vmRestorePointName") String vmRestorePointName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<DiskRestorePointList>> listByRestorePointNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DiskRestorePointInner>> getWithResponseAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        if (diskRestorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            restorePointCollectionName,
                            vmRestorePointName,
                            diskRestorePointName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiskRestorePointInner>> getWithResponseAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        if (diskRestorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                restorePointCollectionName,
                vmRestorePointName,
                diskRestorePointName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DiskRestorePointInner> getAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName) {
        return getWithResponseAsync(
                resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName)
            .flatMap(
                (Response<DiskRestorePointInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiskRestorePointInner get(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName) {
        return getAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName)
            .block();
    }

    /**
     * Get disk restorePoint resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param diskRestorePointName The name of the disk restore point created. Supported characters for the name are
     *     a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return disk restorePoint resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiskRestorePointInner> getWithResponse(
        String resourceGroupName,
        String restorePointCollectionName,
        String vmRestorePointName,
        String diskRestorePointName,
        Context context) {
        return getWithResponseAsync(
                resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, context)
            .block();
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskRestorePointInner>> listByRestorePointSinglePageAsync(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByRestorePoint(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            restorePointCollectionName,
                            vmRestorePointName,
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<DiskRestorePointInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskRestorePointInner>> listByRestorePointSinglePageAsync(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        final String apiVersion = "2020-12-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByRestorePoint(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                restorePointCollectionName,
                vmRestorePointName,
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DiskRestorePointInner> listByRestorePointAsync(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        return new PagedFlux<>(
            () -> listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName),
            nextLink -> listByRestorePointNextSinglePageAsync(nextLink));
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiskRestorePointInner> listByRestorePointAsync(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, Context context) {
        return new PagedFlux<>(
            () ->
                listByRestorePointSinglePageAsync(
                    resourceGroupName, restorePointCollectionName, vmRestorePointName, context),
            nextLink -> listByRestorePointNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskRestorePointInner> listByRestorePoint(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        return new PagedIterable<>(
            listByRestorePointAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName));
    }

    /**
     * Lists diskRestorePoints under a vmRestorePoint.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection that the disk restore point belongs.
     *     Supported characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param vmRestorePointName The name of the vm restore point that the disk disk restore point belongs. Supported
     *     characters for the name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiskRestorePointInner> listByRestorePoint(
        String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, Context context) {
        return new PagedIterable<>(
            listByRestorePointAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskRestorePointInner>> listByRestorePointNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByRestorePointNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DiskRestorePointInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Disk Restore Points operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiskRestorePointInner>> listByRestorePointNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByRestorePointNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
