// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.RestorePointsClient;
import com.azure.resourcemanager.compute.fluent.models.RestorePointInner;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RestorePointsClient. */
public final class RestorePointsClientImpl implements RestorePointsClient {
    private final ClientLogger logger = new ClientLogger(RestorePointsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final RestorePointsService service;

    /** The service client containing this operation class. */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of RestorePointsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RestorePointsClientImpl(ComputeManagementClientImpl client) {
        this.service =
            RestProxy.create(RestorePointsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientRestorePoints to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    private interface RestorePointsService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/restorePointCollections/{restorePointCollectionName}/restorePoints/{restorePointName}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> create(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("restorePointCollectionName") String restorePointCollectionName,
            @PathParam("restorePointName") String restorePointName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RestorePointInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/restorePointCollections/{restorePointCollectionName}/restorePoints/{restorePointName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("restorePointCollectionName") String restorePointCollectionName,
            @PathParam("restorePointName") String restorePointName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/restorePointCollections/{restorePointCollectionName}/restorePoints/{restorePointName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<RestorePointInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("restorePointCollectionName") String restorePointCollectionName,
            @PathParam("restorePointName") String restorePointName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (restorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter restorePointName is required and cannot be null."));
        }
        if (excludeDisks != null) {
            excludeDisks.forEach(e -> e.validate());
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        RestorePointInner parameters = new RestorePointInner();
        parameters.withExcludeDisks(excludeDisks);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            restorePointCollectionName,
                            restorePointName,
                            apiVersion,
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (restorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter restorePointName is required and cannot be null."));
        }
        if (excludeDisks != null) {
            excludeDisks.forEach(e -> e.validate());
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        RestorePointInner parameters = new RestorePointInner();
        parameters.withExcludeDisks(excludeDisks);
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                restorePointCollectionName,
                restorePointName,
                apiVersion,
                parameters,
                accept,
                context);
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<RestorePointInner>, RestorePointInner> beginCreateAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks);
        return this
            .client
            .<RestorePointInner, RestorePointInner>getLroResult(
                mono, this.client.getHttpPipeline(), RestorePointInner.class, RestorePointInner.class, Context.NONE);
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<RestorePointInner>, RestorePointInner> beginCreateAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(
                resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks, context);
        return this
            .client
            .<RestorePointInner, RestorePointInner>getLroResult(
                mono, this.client.getHttpPipeline(), RestorePointInner.class, RestorePointInner.class, context);
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<RestorePointInner>, RestorePointInner> beginCreate(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks) {
        return beginCreateAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks)
            .getSyncPoller();
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<RestorePointInner>, RestorePointInner> beginCreate(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks,
        Context context) {
        return beginCreateAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks, context)
            .getSyncPoller();
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RestorePointInner> createAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks) {
        return beginCreateAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RestorePointInner> createAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        final List<ApiEntityReference> excludeDisks = null;
        return beginCreateAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<RestorePointInner> createAsync(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks,
        Context context) {
        return beginCreateAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RestorePointInner create(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks) {
        return createAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks).block();
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RestorePointInner create(
        String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        final List<ApiEntityReference> excludeDisks = null;
        return createAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks).block();
    }

    /**
     * The operation to create the restore point. Updating properties of an existing restore point is not allowed.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param excludeDisks List of disk resource ids that the customer wishes to exclude from the restore point. If no
     *     disks are specified, all disks will be included.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RestorePointInner create(
        String resourceGroupName,
        String restorePointCollectionName,
        String restorePointName,
        List<ApiEntityReference> excludeDisks,
        Context context) {
        return createAsync(resourceGroupName, restorePointCollectionName, restorePointName, excludeDisks, context)
            .block();
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (restorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter restorePointName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            restorePointCollectionName,
                            restorePointName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (restorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter restorePointName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                restorePointCollectionName,
                restorePointName,
                apiVersion,
                accept,
                context);
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, restorePointCollectionName, restorePointName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, restorePointCollectionName, restorePointName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        return beginDeleteAsync(resourceGroupName, restorePointCollectionName, restorePointName).getSyncPoller();
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String restorePointCollectionName, String restorePointName, Context context) {
        return beginDeleteAsync(resourceGroupName, restorePointCollectionName, restorePointName, context)
            .getSyncPoller();
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        return beginDeleteAsync(resourceGroupName, restorePointCollectionName, restorePointName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName, Context context) {
        return beginDeleteAsync(resourceGroupName, restorePointCollectionName, restorePointName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        deleteAsync(resourceGroupName, restorePointCollectionName, restorePointName).block();
    }

    /**
     * The operation to delete the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the Restore Point Collection.
     * @param restorePointName The name of the restore point.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName, String restorePointCollectionName, String restorePointName, Context context) {
        deleteAsync(resourceGroupName, restorePointCollectionName, restorePointName, context).block();
    }

    /**
     * The operation to get the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RestorePointInner>> getWithResponseAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (restorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter restorePointName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            restorePointCollectionName,
                            restorePointName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The operation to get the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RestorePointInner>> getWithResponseAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (restorePointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter restorePointName is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                restorePointCollectionName,
                restorePointName,
                apiVersion,
                accept,
                context);
    }

    /**
     * The operation to get the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RestorePointInner> getAsync(
        String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        return getWithResponseAsync(resourceGroupName, restorePointCollectionName, restorePointName)
            .flatMap(
                (Response<RestorePointInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * The operation to get the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RestorePointInner get(String resourceGroupName, String restorePointCollectionName, String restorePointName) {
        return getAsync(resourceGroupName, restorePointCollectionName, restorePointName).block();
    }

    /**
     * The operation to get the restore point.
     *
     * @param resourceGroupName The name of the resource group.
     * @param restorePointCollectionName The name of the restore point collection.
     * @param restorePointName The name of the restore point.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return restore Point details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RestorePointInner> getWithResponse(
        String resourceGroupName, String restorePointCollectionName, String restorePointName, Context context) {
        return getWithResponseAsync(resourceGroupName, restorePointCollectionName, restorePointName, context).block();
    }
}
