// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains the security related information for the resource. */
@Fluent
public final class DiskSecurityProfile {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DiskSecurityProfile.class);

    /*
     * Specifies the SecurityType of the VM. Applicable for OS disks only.
     */
    @JsonProperty(value = "securityType")
    private DiskSecurityTypes securityType;

    /**
     * Get the securityType property: Specifies the SecurityType of the VM. Applicable for OS disks only.
     *
     * @return the securityType value.
     */
    public DiskSecurityTypes securityType() {
        return this.securityType;
    }

    /**
     * Set the securityType property: Specifies the SecurityType of the VM. Applicable for OS disks only.
     *
     * @param securityType the securityType value to set.
     * @return the DiskSecurityProfile object itself.
     */
    public DiskSecurityProfile withSecurityType(DiskSecurityTypes securityType) {
        this.securityType = securityType;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
