// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;

/** Contains encryption settings for an OS disk image. */
@Immutable
public final class OSDiskImageEncryption extends DiskImageEncryption {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(OSDiskImageEncryption.class);

    /** {@inheritDoc} */
    @Override
    public OSDiskImageEncryption withDiskEncryptionSetId(String diskEncryptionSetId) {
        super.withDiskEncryptionSetId(diskEncryptionSetId);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
