// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for OrchestrationMode. */
public final class OrchestrationMode extends ExpandableStringEnum<OrchestrationMode> {
    /** Static value Uniform for OrchestrationMode. */
    public static final OrchestrationMode UNIFORM = fromString("Uniform");

    /** Static value Flexible for OrchestrationMode. */
    public static final OrchestrationMode FLEXIBLE = fromString("Flexible");

    /**
     * Creates or finds a OrchestrationMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OrchestrationMode.
     */
    @JsonCreator
    public static OrchestrationMode fromString(String name) {
        return fromString(name, OrchestrationMode.class);
    }

    /** @return known OrchestrationMode values. */
    public static Collection<OrchestrationMode> values() {
        return values(OrchestrationMode.class);
    }
}
