// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes the public IP Sku. */
@Fluent
public final class PublicIpAddressSku {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PublicIpAddressSku.class);

    /*
     * Specify public IP sku name
     */
    @JsonProperty(value = "publicIPAddressSkuName", required = true)
    private PublicIpAddressSkuName publicIpAddressSkuName;

    /*
     * Specify public IP sku tier
     */
    @JsonProperty(value = "publicIPAddressSkuTier")
    private PublicIpAddressSkuTier publicIpAddressSkuTier;

    /**
     * Get the publicIpAddressSkuName property: Specify public IP sku name.
     *
     * @return the publicIpAddressSkuName value.
     */
    public PublicIpAddressSkuName publicIpAddressSkuName() {
        return this.publicIpAddressSkuName;
    }

    /**
     * Set the publicIpAddressSkuName property: Specify public IP sku name.
     *
     * @param publicIpAddressSkuName the publicIpAddressSkuName value to set.
     * @return the PublicIpAddressSku object itself.
     */
    public PublicIpAddressSku withPublicIpAddressSkuName(PublicIpAddressSkuName publicIpAddressSkuName) {
        this.publicIpAddressSkuName = publicIpAddressSkuName;
        return this;
    }

    /**
     * Get the publicIpAddressSkuTier property: Specify public IP sku tier.
     *
     * @return the publicIpAddressSkuTier value.
     */
    public PublicIpAddressSkuTier publicIpAddressSkuTier() {
        return this.publicIpAddressSkuTier;
    }

    /**
     * Set the publicIpAddressSkuTier property: Specify public IP sku tier.
     *
     * @param publicIpAddressSkuTier the publicIpAddressSkuTier value to set.
     * @return the PublicIpAddressSku object itself.
     */
    public PublicIpAddressSku withPublicIpAddressSkuTier(PublicIpAddressSkuTier publicIpAddressSkuTier) {
        this.publicIpAddressSkuTier = publicIpAddressSkuTier;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publicIpAddressSkuName() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property publicIpAddressSkuName in model PublicIpAddressSku"));
        }
    }
}
