// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Profile for gallery sharing to subscription or tenant. */
@Fluent
public final class SharingProfile {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SharingProfile.class);

    /*
     * This property allows you to specify the permission of sharing gallery.
     * <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**
     */
    @JsonProperty(value = "permissions")
    private GallerySharingPermissionTypes permissions;

    /*
     * A list of sharing profile groups.
     */
    @JsonProperty(value = "groups", access = JsonProperty.Access.WRITE_ONLY)
    private List<SharingProfileGroup> groups;

    /**
     * Get the permissions property: This property allows you to specify the permission of sharing gallery.
     * &lt;br&gt;&lt;br&gt; Possible values are: &lt;br&gt;&lt;br&gt; **Private** &lt;br&gt;&lt;br&gt; **Groups**.
     *
     * @return the permissions value.
     */
    public GallerySharingPermissionTypes permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: This property allows you to specify the permission of sharing gallery.
     * &lt;br&gt;&lt;br&gt; Possible values are: &lt;br&gt;&lt;br&gt; **Private** &lt;br&gt;&lt;br&gt; **Groups**.
     *
     * @param permissions the permissions value to set.
     * @return the SharingProfile object itself.
     */
    public SharingProfile withPermissions(GallerySharingPermissionTypes permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Get the groups property: A list of sharing profile groups.
     *
     * @return the groups value.
     */
    public List<SharingProfileGroup> groups() {
        return this.groups;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (groups() != null) {
            groups().forEach(e -> e.validate());
        }
    }
}
