// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Describes the properties of a Virtual Machine software patch. */
@Immutable
public final class VirtualMachineSoftwarePatchProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(VirtualMachineSoftwarePatchProperties.class);

    /*
     * A unique identifier for the patch.
     */
    @JsonProperty(value = "patchId", access = JsonProperty.Access.WRITE_ONLY)
    private String patchId;

    /*
     * The friendly name of the patch.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The version number of the patch. This property applies only to Linux
     * patches.
     */
    @JsonProperty(value = "version", access = JsonProperty.Access.WRITE_ONLY)
    private String version;

    /*
     * The KBID of the patch. Only applies to Windows patches.
     */
    @JsonProperty(value = "kbId", access = JsonProperty.Access.WRITE_ONLY)
    private String kbId;

    /*
     * The classification(s) of the patch as provided by the patch publisher.
     */
    @JsonProperty(value = "classifications", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> classifications;

    /*
     * Describes the reboot requirements of the patch.
     */
    @JsonProperty(value = "rebootBehavior", access = JsonProperty.Access.WRITE_ONLY)
    private VMGuestPatchRebootBehavior rebootBehavior;

    /*
     * The activity ID of the operation that produced this result. It is used
     * to correlate across CRP and extension logs.
     */
    @JsonProperty(value = "activityId", access = JsonProperty.Access.WRITE_ONLY)
    private String activityId;

    /*
     * The UTC timestamp when the repository published this patch.
     */
    @JsonProperty(value = "publishedDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime publishedDate;

    /*
     * The UTC timestamp of the last update to this patch record.
     */
    @JsonProperty(value = "lastModifiedDateTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedDateTime;

    /*
     * Describes the availability of a given patch.
     */
    @JsonProperty(value = "assessmentState", access = JsonProperty.Access.WRITE_ONLY)
    private PatchAssessmentState assessmentState;

    /**
     * Get the patchId property: A unique identifier for the patch.
     *
     * @return the patchId value.
     */
    public String patchId() {
        return this.patchId;
    }

    /**
     * Get the name property: The friendly name of the patch.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the version property: The version number of the patch. This property applies only to Linux patches.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the kbId property: The KBID of the patch. Only applies to Windows patches.
     *
     * @return the kbId value.
     */
    public String kbId() {
        return this.kbId;
    }

    /**
     * Get the classifications property: The classification(s) of the patch as provided by the patch publisher.
     *
     * @return the classifications value.
     */
    public List<String> classifications() {
        return this.classifications;
    }

    /**
     * Get the rebootBehavior property: Describes the reboot requirements of the patch.
     *
     * @return the rebootBehavior value.
     */
    public VMGuestPatchRebootBehavior rebootBehavior() {
        return this.rebootBehavior;
    }

    /**
     * Get the activityId property: The activity ID of the operation that produced this result. It is used to correlate
     * across CRP and extension logs.
     *
     * @return the activityId value.
     */
    public String activityId() {
        return this.activityId;
    }

    /**
     * Get the publishedDate property: The UTC timestamp when the repository published this patch.
     *
     * @return the publishedDate value.
     */
    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    /**
     * Get the lastModifiedDateTime property: The UTC timestamp of the last update to this patch record.
     *
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Get the assessmentState property: Describes the availability of a given patch.
     *
     * @return the assessmentState value.
     */
    public PatchAssessmentState assessmentState() {
        return this.assessmentState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
