/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.EncryptionSetIdentity;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class DiskEncryptionSetInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskEncryptionSetInner.class);
    @JsonProperty(value="identity")
    private EncryptionSetIdentity identity;
    @JsonProperty(value="properties.encryptionType")
    private DiskEncryptionSetType encryptionType;
    @JsonProperty(value="properties.activeKey")
    private KeyForDiskEncryptionSet activeKey;
    @JsonProperty(value="properties.previousKeys", access=JsonProperty.Access.WRITE_ONLY)
    private List<KeyForDiskEncryptionSet> previousKeys;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.rotationToLatestKeyVersionEnabled")
    private Boolean rotationToLatestKeyVersionEnabled;
    @JsonProperty(value="properties.lastKeyRotationTimestamp", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastKeyRotationTimestamp;

    public EncryptionSetIdentity identity() {
        return this.identity;
    }

    public DiskEncryptionSetInner withIdentity(EncryptionSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public DiskEncryptionSetType encryptionType() {
        return this.encryptionType;
    }

    public DiskEncryptionSetInner withEncryptionType(DiskEncryptionSetType encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    public KeyForDiskEncryptionSet activeKey() {
        return this.activeKey;
    }

    public DiskEncryptionSetInner withActiveKey(KeyForDiskEncryptionSet activeKey) {
        this.activeKey = activeKey;
        return this;
    }

    public List<KeyForDiskEncryptionSet> previousKeys() {
        return this.previousKeys;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.rotationToLatestKeyVersionEnabled;
    }

    public DiskEncryptionSetInner withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        this.rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled;
        return this;
    }

    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    public DiskEncryptionSetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DiskEncryptionSetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.activeKey() != null) {
            this.activeKey().validate();
        }
        if (this.previousKeys() != null) {
            this.previousKeys().forEach(e -> e.validate());
        }
    }
}

