/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.RestorePointInner;
import com.azure.resourcemanager.compute.models.RestorePointCollectionSourceProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class RestorePointCollectionInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RestorePointCollectionInner.class);
    @JsonProperty(value="properties.source")
    private RestorePointCollectionSourceProperties source;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.restorePointCollectionId", access=JsonProperty.Access.WRITE_ONLY)
    private String restorePointCollectionId;
    @JsonProperty(value="properties.restorePoints", access=JsonProperty.Access.WRITE_ONLY)
    private List<RestorePointInner> restorePoints;

    public RestorePointCollectionSourceProperties source() {
        return this.source;
    }

    public RestorePointCollectionInner withSource(RestorePointCollectionSourceProperties source) {
        this.source = source;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String restorePointCollectionId() {
        return this.restorePointCollectionId;
    }

    public List<RestorePointInner> restorePoints() {
        return this.restorePoints;
    }

    public RestorePointCollectionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RestorePointCollectionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.restorePoints() != null) {
            this.restorePoints().forEach(e -> e.validate());
        }
    }
}

