/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PirSharedGalleryResource;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class SharedGalleryImageInner
extends PirSharedGalleryResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SharedGalleryImageInner.class);
    @JsonProperty(value="properties.osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.osState")
    private OperatingSystemStateTypes osState;
    @JsonProperty(value="properties.endOfLifeDate")
    private OffsetDateTime endOfLifeDate;
    @JsonProperty(value="properties.identifier")
    private GalleryImageIdentifier identifier;
    @JsonProperty(value="properties.recommended")
    private RecommendedMachineConfiguration recommended;
    @JsonProperty(value="properties.disallowed")
    private Disallowed disallowed;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="properties.features")
    private List<GalleryImageFeature> features;
    @JsonProperty(value="properties.purchasePlan")
    private ImagePurchasePlan purchasePlan;

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public SharedGalleryImageInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public SharedGalleryImageInner withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public SharedGalleryImageInner withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public SharedGalleryImageInner withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.recommended;
    }

    public SharedGalleryImageInner withRecommended(RecommendedMachineConfiguration recommended) {
        this.recommended = recommended;
        return this;
    }

    public Disallowed disallowed() {
        return this.disallowed;
    }

    public SharedGalleryImageInner withDisallowed(Disallowed disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public SharedGalleryImageInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public List<GalleryImageFeature> features() {
        return this.features;
    }

    public SharedGalleryImageInner withFeatures(List<GalleryImageFeature> features) {
        this.features = features;
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    public SharedGalleryImageInner withPurchasePlan(ImagePurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    @Override
    public SharedGalleryImageInner withUniqueId(String uniqueId) {
        super.withUniqueId(uniqueId);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.identifier() != null) {
            this.identifier().validate();
        }
        if (this.recommended() != null) {
            this.recommended().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
    }
}

