/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.DiskState;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.SnapshotSku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonFlatten
public class SnapshotInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SnapshotInner.class);
    @JsonProperty(value="managedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String managedBy;
    @JsonProperty(value="sku")
    private SnapshotSku sku;
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties.timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;
    @JsonProperty(value="properties.osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="properties.purchasePlan")
    private PurchasePlanAutoGenerated purchasePlan;
    @JsonProperty(value="properties.creationData")
    private CreationData creationData;
    @JsonProperty(value="properties.diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="properties.diskSizeBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long diskSizeBytes;
    @JsonProperty(value="properties.diskState", access=JsonProperty.Access.WRITE_ONLY)
    private DiskState diskState;
    @JsonProperty(value="properties.uniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String uniqueId;
    @JsonProperty(value="properties.encryptionSettingsCollection")
    private EncryptionSettingsCollection encryptionSettingsCollection;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.incremental")
    private Boolean incremental;
    @JsonProperty(value="properties.encryption")
    private Encryption encryption;
    @JsonProperty(value="properties.networkAccessPolicy")
    private NetworkAccessPolicy networkAccessPolicy;
    @JsonProperty(value="properties.diskAccessId")
    private String diskAccessId;
    @JsonProperty(value="properties.supportsHibernation")
    private Boolean supportsHibernation;

    public String managedBy() {
        return this.managedBy;
    }

    public SnapshotSku sku() {
        return this.sku;
    }

    public SnapshotInner withSku(SnapshotSku sku) {
        this.sku = sku;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public SnapshotInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public SnapshotInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public SnapshotInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public SnapshotInner withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public CreationData creationData() {
        return this.creationData;
    }

    public SnapshotInner withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public SnapshotInner withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Long diskSizeBytes() {
        return this.diskSizeBytes;
    }

    public DiskState diskState() {
        return this.diskState;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public SnapshotInner withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean incremental() {
        return this.incremental;
    }

    public SnapshotInner withIncremental(Boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public SnapshotInner withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public SnapshotInner withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public SnapshotInner withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public SnapshotInner withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public SnapshotInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SnapshotInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.creationData() != null) {
            this.creationData().validate();
        }
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }
}

