/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DiskSku;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PropertyUpdatesInProgress;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class DiskUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskUpdate.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="sku")
    private DiskSku sku;
    @JsonProperty(value="properties.osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="properties.encryptionSettingsCollection")
    private EncryptionSettingsCollection encryptionSettingsCollection;
    @JsonProperty(value="properties.diskIOPSReadWrite")
    private Long diskIopsReadWrite;
    @JsonProperty(value="properties.diskMBpsReadWrite")
    private Long diskMBpsReadWrite;
    @JsonProperty(value="properties.diskIOPSReadOnly")
    private Long diskIopsReadOnly;
    @JsonProperty(value="properties.diskMBpsReadOnly")
    private Long diskMBpsReadOnly;
    @JsonProperty(value="properties.maxShares")
    private Integer maxShares;
    @JsonProperty(value="properties.encryption")
    private Encryption encryption;
    @JsonProperty(value="properties.networkAccessPolicy")
    private NetworkAccessPolicy networkAccessPolicy;
    @JsonProperty(value="properties.diskAccessId")
    private String diskAccessId;
    @JsonProperty(value="properties.tier")
    private String tier;
    @JsonProperty(value="properties.burstingEnabled")
    private Boolean burstingEnabled;
    @JsonProperty(value="properties.purchasePlan")
    private PurchasePlanAutoGenerated purchasePlan;
    @JsonProperty(value="properties.propertyUpdatesInProgress", access=JsonProperty.Access.WRITE_ONLY)
    private PropertyUpdatesInProgress propertyUpdatesInProgress;
    @JsonProperty(value="properties.supportsHibernation")
    private Boolean supportsHibernation;

    public Map<String, String> tags() {
        return this.tags;
    }

    public DiskUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public DiskSku sku() {
        return this.sku;
    }

    public DiskUpdate withSku(DiskSku sku) {
        this.sku = sku;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public DiskUpdate withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public DiskUpdate withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public DiskUpdate withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    public DiskUpdate withDiskIopsReadWrite(Long diskIopsReadWrite) {
        this.diskIopsReadWrite = diskIopsReadWrite;
        return this;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public DiskUpdate withDiskMBpsReadWrite(Long diskMBpsReadWrite) {
        this.diskMBpsReadWrite = diskMBpsReadWrite;
        return this;
    }

    public Long diskIopsReadOnly() {
        return this.diskIopsReadOnly;
    }

    public DiskUpdate withDiskIopsReadOnly(Long diskIopsReadOnly) {
        this.diskIopsReadOnly = diskIopsReadOnly;
        return this;
    }

    public Long diskMBpsReadOnly() {
        return this.diskMBpsReadOnly;
    }

    public DiskUpdate withDiskMBpsReadOnly(Long diskMBpsReadOnly) {
        this.diskMBpsReadOnly = diskMBpsReadOnly;
        return this;
    }

    public Integer maxShares() {
        return this.maxShares;
    }

    public DiskUpdate withMaxShares(Integer maxShares) {
        this.maxShares = maxShares;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public DiskUpdate withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public DiskUpdate withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public DiskUpdate withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public DiskUpdate withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public Boolean burstingEnabled() {
        return this.burstingEnabled;
    }

    public DiskUpdate withBurstingEnabled(Boolean burstingEnabled) {
        this.burstingEnabled = burstingEnabled;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public DiskUpdate withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public PropertyUpdatesInProgress propertyUpdatesInProgress() {
        return this.propertyUpdatesInProgress;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public DiskUpdate withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.propertyUpdatesInProgress() != null) {
            this.propertyUpdatesInProgress().validate();
        }
    }
}

