// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileInner;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in GalleryInVMAccessControlProfilesClient.
 */
public interface GalleryInVMAccessControlProfilesClient {
    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile);

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile);

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile);

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context);

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInVMAccessControlProfileInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile);

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileInner createOrUpdate(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile);

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileInner createOrUpdate(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile,
        Context context);

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile);

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginUpdateAsync(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile);

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginUpdate(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile);

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner> beginUpdate(
        String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile, Context context);

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInVMAccessControlProfileInner> updateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile);

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileInner update(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile);

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileInner update(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile,
        Context context);

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<GalleryInVMAccessControlProfileInner>> getWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName);

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GalleryInVMAccessControlProfileInner> getAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName);

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GalleryInVMAccessControlProfileInner> getWithResponse(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, Context context);

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GalleryInVMAccessControlProfileInner get(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName);

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName);

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName);

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName);

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, Context context);

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName);

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName);

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context);

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<GalleryInVMAccessControlProfileInner> listByGalleryAsync(String resourceGroupName, String galleryName);

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryInVMAccessControlProfileInner> listByGallery(String resourceGroupName, String galleryName);

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GalleryInVMAccessControlProfileInner> listByGallery(String resourceGroupName, String galleryName,
        Context context);
}
