// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.Architecture;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * Describes the properties of a gallery image definition.
 */
@Fluent
public final class SharedGalleryImageProperties implements JsonSerializable<SharedGalleryImageProperties> {
    /*
     * This property allows you to specify the type of the OS that is included in the disk when creating a VM from a
     * managed image. Possible values are: **Windows,** **Linux.**
     */
    private OperatingSystemTypes osType;

    /*
     * This property allows the user to specify whether the virtual machines created under this image are 'Generalized'
     * or 'Specialized'.
     */
    private OperatingSystemStateTypes osState;

    /*
     * The end of life date of the gallery image definition. This property can be used for decommissioning purposes.
     * This property is updatable.
     */
    private OffsetDateTime endOfLifeDate;

    /*
     * This is the gallery image definition identifier.
     */
    private GalleryImageIdentifier identifier;

    /*
     * The properties describe the recommended machine configuration for this Image Definition. These properties are
     * updatable.
     */
    private RecommendedMachineConfiguration recommended;

    /*
     * Describes the disallowed disk types.
     */
    private Disallowed disallowed;

    /*
     * The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    private HyperVGeneration hyperVGeneration;

    /*
     * A list of gallery image features.
     */
    private List<GalleryImageFeature> features;

    /*
     * Describes the gallery image definition purchase plan. This is used by marketplace images.
     */
    private ImagePurchasePlan purchasePlan;

    /*
     * CPU architecture supported by an OS disk.
     */
    private Architecture architecture;

    /*
     * Privacy statement uri for the current community gallery image.
     */
    private String privacyStatementUri;

    /*
     * End-user license agreement for the current community gallery image.
     */
    private String eula;

    /*
     * The artifact tags of a shared gallery resource.
     */
    private Map<String, String> artifactTags;

    /**
     * Creates an instance of SharedGalleryImageProperties class.
     */
    public SharedGalleryImageProperties() {
    }

    /**
     * Get the osType property: This property allows you to specify the type of the OS that is included in the disk when
     * creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
     * 
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Set the osType property: This property allows you to specify the type of the OS that is included in the disk when
     * creating a VM from a managed image. Possible values are: **Windows,** **Linux.**.
     * 
     * @param osType the osType value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the osState property: This property allows the user to specify whether the virtual machines created under
     * this image are 'Generalized' or 'Specialized'.
     * 
     * @return the osState value.
     */
    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    /**
     * Set the osState property: This property allows the user to specify whether the virtual machines created under
     * this image are 'Generalized' or 'Specialized'.
     * 
     * @param osState the osState value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    /**
     * Get the endOfLifeDate property: The end of life date of the gallery image definition. This property can be used
     * for decommissioning purposes. This property is updatable.
     * 
     * @return the endOfLifeDate value.
     */
    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    /**
     * Set the endOfLifeDate property: The end of life date of the gallery image definition. This property can be used
     * for decommissioning purposes. This property is updatable.
     * 
     * @param endOfLifeDate the endOfLifeDate value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    /**
     * Get the identifier property: This is the gallery image definition identifier.
     * 
     * @return the identifier value.
     */
    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    /**
     * Set the identifier property: This is the gallery image definition identifier.
     * 
     * @param identifier the identifier value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    /**
     * Get the recommended property: The properties describe the recommended machine configuration for this Image
     * Definition. These properties are updatable.
     * 
     * @return the recommended value.
     */
    public RecommendedMachineConfiguration recommended() {
        return this.recommended;
    }

    /**
     * Set the recommended property: The properties describe the recommended machine configuration for this Image
     * Definition. These properties are updatable.
     * 
     * @param recommended the recommended value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withRecommended(RecommendedMachineConfiguration recommended) {
        this.recommended = recommended;
        return this;
    }

    /**
     * Get the disallowed property: Describes the disallowed disk types.
     * 
     * @return the disallowed value.
     */
    public Disallowed disallowed() {
        return this.disallowed;
    }

    /**
     * Set the disallowed property: Describes the disallowed disk types.
     * 
     * @param disallowed the disallowed value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withDisallowed(Disallowed disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    /**
     * Get the hyperVGeneration property: The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     * 
     * @return the hyperVGeneration value.
     */
    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    /**
     * Set the hyperVGeneration property: The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     * 
     * @param hyperVGeneration the hyperVGeneration value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    /**
     * Get the features property: A list of gallery image features.
     * 
     * @return the features value.
     */
    public List<GalleryImageFeature> features() {
        return this.features;
    }

    /**
     * Set the features property: A list of gallery image features.
     * 
     * @param features the features value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withFeatures(List<GalleryImageFeature> features) {
        this.features = features;
        return this;
    }

    /**
     * Get the purchasePlan property: Describes the gallery image definition purchase plan. This is used by marketplace
     * images.
     * 
     * @return the purchasePlan value.
     */
    public ImagePurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    /**
     * Set the purchasePlan property: Describes the gallery image definition purchase plan. This is used by marketplace
     * images.
     * 
     * @param purchasePlan the purchasePlan value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withPurchasePlan(ImagePurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    /**
     * Get the architecture property: CPU architecture supported by an OS disk.
     * 
     * @return the architecture value.
     */
    public Architecture architecture() {
        return this.architecture;
    }

    /**
     * Set the architecture property: CPU architecture supported by an OS disk.
     * 
     * @param architecture the architecture value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    /**
     * Get the privacyStatementUri property: Privacy statement uri for the current community gallery image.
     * 
     * @return the privacyStatementUri value.
     */
    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    /**
     * Set the privacyStatementUri property: Privacy statement uri for the current community gallery image.
     * 
     * @param privacyStatementUri the privacyStatementUri value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    /**
     * Get the eula property: End-user license agreement for the current community gallery image.
     * 
     * @return the eula value.
     */
    public String eula() {
        return this.eula;
    }

    /**
     * Set the eula property: End-user license agreement for the current community gallery image.
     * 
     * @param eula the eula value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    /**
     * Get the artifactTags property: The artifact tags of a shared gallery resource.
     * 
     * @return the artifactTags value.
     */
    public Map<String, String> artifactTags() {
        return this.artifactTags;
    }

    /**
     * Set the artifactTags property: The artifact tags of a shared gallery resource.
     * 
     * @param artifactTags the artifactTags value to set.
     * @return the SharedGalleryImageProperties object itself.
     */
    public SharedGalleryImageProperties withArtifactTags(Map<String, String> artifactTags) {
        this.artifactTags = artifactTags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (osType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property osType in model SharedGalleryImageProperties"));
        }
        if (osState() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property osState in model SharedGalleryImageProperties"));
        }
        if (identifier() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property identifier in model SharedGalleryImageProperties"));
        } else {
            identifier().validate();
        }
        if (recommended() != null) {
            recommended().validate();
        }
        if (disallowed() != null) {
            disallowed().validate();
        }
        if (features() != null) {
            features().forEach(e -> e.validate());
        }
        if (purchasePlan() != null) {
            purchasePlan().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SharedGalleryImageProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("osState", this.osState == null ? null : this.osState.toString());
        jsonWriter.writeJsonField("identifier", this.identifier);
        jsonWriter.writeStringField("endOfLifeDate",
            this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeJsonField("recommended", this.recommended);
        jsonWriter.writeJsonField("disallowed", this.disallowed);
        jsonWriter.writeStringField("hyperVGeneration",
            this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeArrayField("features", this.features, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("purchasePlan", this.purchasePlan);
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        jsonWriter.writeStringField("privacyStatementUri", this.privacyStatementUri);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeMapField("artifactTags", this.artifactTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharedGalleryImageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharedGalleryImageProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SharedGalleryImageProperties.
     */
    public static SharedGalleryImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharedGalleryImageProperties deserializedSharedGalleryImageProperties = new SharedGalleryImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("osType".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.osType
                        = OperatingSystemTypes.fromString(reader.getString());
                } else if ("osState".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.osState
                        = OperatingSystemStateTypes.fromString(reader.getString());
                } else if ("identifier".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.identifier = GalleryImageIdentifier.fromJson(reader);
                } else if ("endOfLifeDate".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.endOfLifeDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("recommended".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.recommended
                        = RecommendedMachineConfiguration.fromJson(reader);
                } else if ("disallowed".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.disallowed = Disallowed.fromJson(reader);
                } else if ("hyperVGeneration".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.hyperVGeneration
                        = HyperVGeneration.fromString(reader.getString());
                } else if ("features".equals(fieldName)) {
                    List<GalleryImageFeature> features
                        = reader.readArray(reader1 -> GalleryImageFeature.fromJson(reader1));
                    deserializedSharedGalleryImageProperties.features = features;
                } else if ("purchasePlan".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.purchasePlan = ImagePurchasePlan.fromJson(reader);
                } else if ("architecture".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.architecture = Architecture.fromString(reader.getString());
                } else if ("privacyStatementUri".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.privacyStatementUri = reader.getString();
                } else if ("eula".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.eula = reader.getString();
                } else if ("artifactTags".equals(fieldName)) {
                    Map<String, String> artifactTags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSharedGalleryImageProperties.artifactTags = artifactTags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharedGalleryImageProperties;
        });
    }
}
