// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * CPU architecture supported by an OS disk.
 */
public final class Architecture extends ExpandableStringEnum<Architecture> {
    /**
     * Static value x64 for Architecture.
     */
    public static final Architecture X64 = fromString("x64");

    /**
     * Static value Arm64 for Architecture.
     */
    public static final Architecture ARM64 = fromString("Arm64");

    /**
     * Creates a new instance of Architecture value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Architecture() {
    }

    /**
     * Creates or finds a Architecture from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Architecture.
     */
    public static Architecture fromString(String name) {
        return fromString(name, Architecture.class);
    }

    /**
     * Gets known Architecture values.
     * 
     * @return known Architecture values.
     */
    public static Collection<Architecture> values() {
        return values(Architecture.class);
    }
}
