// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * This is the storage profile of a Gallery Image Version.
 */
@Fluent
public final class GalleryImageVersionStorageProfile implements JsonSerializable<GalleryImageVersionStorageProfile> {
    /*
     * The source of the gallery artifact version.
     */
    private GalleryArtifactVersionFullSource source;

    /*
     * This is the OS disk image.
     */
    private GalleryOSDiskImage osDiskImage;

    /*
     * A list of data disk images.
     */
    private List<GalleryDataDiskImage> dataDiskImages;

    /**
     * Creates an instance of GalleryImageVersionStorageProfile class.
     */
    public GalleryImageVersionStorageProfile() {
    }

    /**
     * Get the source property: The source of the gallery artifact version.
     * 
     * @return the source value.
     */
    public GalleryArtifactVersionFullSource source() {
        return this.source;
    }

    /**
     * Set the source property: The source of the gallery artifact version.
     * 
     * @param source the source value to set.
     * @return the GalleryImageVersionStorageProfile object itself.
     */
    public GalleryImageVersionStorageProfile withSource(GalleryArtifactVersionFullSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the osDiskImage property: This is the OS disk image.
     * 
     * @return the osDiskImage value.
     */
    public GalleryOSDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    /**
     * Set the osDiskImage property: This is the OS disk image.
     * 
     * @param osDiskImage the osDiskImage value to set.
     * @return the GalleryImageVersionStorageProfile object itself.
     */
    public GalleryImageVersionStorageProfile withOsDiskImage(GalleryOSDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    /**
     * Get the dataDiskImages property: A list of data disk images.
     * 
     * @return the dataDiskImages value.
     */
    public List<GalleryDataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    /**
     * Set the dataDiskImages property: A list of data disk images.
     * 
     * @param dataDiskImages the dataDiskImages value to set.
     * @return the GalleryImageVersionStorageProfile object itself.
     */
    public GalleryImageVersionStorageProfile withDataDiskImages(List<GalleryDataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() != null) {
            source().validate();
        }
        if (osDiskImage() != null) {
            osDiskImage().validate();
        }
        if (dataDiskImages() != null) {
            dataDiskImages().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", this.source);
        jsonWriter.writeJsonField("osDiskImage", this.osDiskImage);
        jsonWriter.writeArrayField("dataDiskImages", this.dataDiskImages,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryImageVersionStorageProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryImageVersionStorageProfile if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryImageVersionStorageProfile.
     */
    public static GalleryImageVersionStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryImageVersionStorageProfile deserializedGalleryImageVersionStorageProfile
                = new GalleryImageVersionStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("source".equals(fieldName)) {
                    deserializedGalleryImageVersionStorageProfile.source
                        = GalleryArtifactVersionFullSource.fromJson(reader);
                } else if ("osDiskImage".equals(fieldName)) {
                    deserializedGalleryImageVersionStorageProfile.osDiskImage = GalleryOSDiskImage.fromJson(reader);
                } else if ("dataDiskImages".equals(fieldName)) {
                    List<GalleryDataDiskImage> dataDiskImages
                        = reader.readArray(reader1 -> GalleryDataDiskImage.fromJson(reader1));
                    deserializedGalleryImageVersionStorageProfile.dataDiskImages = dataDiskImages;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryImageVersionStorageProfile;
        });
    }
}
