// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input for OrchestrationServiceState.
 */
@Fluent
public final class OrchestrationServiceStateInput implements JsonSerializable<OrchestrationServiceStateInput> {
    /*
     * The name of the service.
     */
    private OrchestrationServiceNames serviceName;

    /*
     * The action to be performed.
     */
    private OrchestrationServiceStateAction action;

    /**
     * Creates an instance of OrchestrationServiceStateInput class.
     */
    public OrchestrationServiceStateInput() {
    }

    /**
     * Get the serviceName property: The name of the service.
     * 
     * @return the serviceName value.
     */
    public OrchestrationServiceNames serviceName() {
        return this.serviceName;
    }

    /**
     * Set the serviceName property: The name of the service.
     * 
     * @param serviceName the serviceName value to set.
     * @return the OrchestrationServiceStateInput object itself.
     */
    public OrchestrationServiceStateInput withServiceName(OrchestrationServiceNames serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    /**
     * Get the action property: The action to be performed.
     * 
     * @return the action value.
     */
    public OrchestrationServiceStateAction action() {
        return this.action;
    }

    /**
     * Set the action property: The action to be performed.
     * 
     * @param action the action value to set.
     * @return the OrchestrationServiceStateInput object itself.
     */
    public OrchestrationServiceStateInput withAction(OrchestrationServiceStateAction action) {
        this.action = action;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serviceName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property serviceName in model OrchestrationServiceStateInput"));
        }
        if (action() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property action in model OrchestrationServiceStateInput"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OrchestrationServiceStateInput.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName == null ? null : this.serviceName.toString());
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OrchestrationServiceStateInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OrchestrationServiceStateInput if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OrchestrationServiceStateInput.
     */
    public static OrchestrationServiceStateInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OrchestrationServiceStateInput deserializedOrchestrationServiceStateInput
                = new OrchestrationServiceStateInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceName".equals(fieldName)) {
                    deserializedOrchestrationServiceStateInput.serviceName
                        = OrchestrationServiceNames.fromString(reader.getString());
                } else if ("action".equals(fieldName)) {
                    deserializedOrchestrationServiceStateInput.action
                        = OrchestrationServiceStateAction.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOrchestrationServiceStateInput;
        });
    }
}
