// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the required information to reference a compute gallery application version.
 */
@Fluent
public final class VMGalleryApplication implements JsonSerializable<VMGalleryApplication> {
    /*
     * Optional, Specifies a passthrough value for more generic context.
     */
    private String tags;

    /*
     * Optional, Specifies the order in which the packages have to be installed
     */
    private Integer order;

    /*
     * Specifies the GalleryApplicationVersion resource id on the form of
     * /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{
     * galleryName}/applications/{application}/versions/{version}
     */
    private String packageReferenceId;

    /*
     * Optional, Specifies the uri to an azure blob that will replace the default configuration for the package if
     * provided
     */
    private String configurationReference;

    /*
     * Optional, If true, any failure for any operation in the VmApplication will fail the deployment
     */
    private Boolean treatFailureAsDeploymentFailure;

    /*
     * If set to true, when a new Gallery Application version is available in PIR/SIG, it will be automatically updated
     * for the VM/VMSS
     */
    private Boolean enableAutomaticUpgrade;

    /**
     * Creates an instance of VMGalleryApplication class.
     */
    public VMGalleryApplication() {
    }

    /**
     * Get the tags property: Optional, Specifies a passthrough value for more generic context.
     * 
     * @return the tags value.
     */
    public String tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Optional, Specifies a passthrough value for more generic context.
     * 
     * @param tags the tags value to set.
     * @return the VMGalleryApplication object itself.
     */
    public VMGalleryApplication withTags(String tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the order property: Optional, Specifies the order in which the packages have to be installed.
     * 
     * @return the order value.
     */
    public Integer order() {
        return this.order;
    }

    /**
     * Set the order property: Optional, Specifies the order in which the packages have to be installed.
     * 
     * @param order the order value to set.
     * @return the VMGalleryApplication object itself.
     */
    public VMGalleryApplication withOrder(Integer order) {
        this.order = order;
        return this;
    }

    /**
     * Get the packageReferenceId property: Specifies the GalleryApplicationVersion resource id on the form of
     * /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.
     * 
     * @return the packageReferenceId value.
     */
    public String packageReferenceId() {
        return this.packageReferenceId;
    }

    /**
     * Set the packageReferenceId property: Specifies the GalleryApplicationVersion resource id on the form of
     * /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.
     * 
     * @param packageReferenceId the packageReferenceId value to set.
     * @return the VMGalleryApplication object itself.
     */
    public VMGalleryApplication withPackageReferenceId(String packageReferenceId) {
        this.packageReferenceId = packageReferenceId;
        return this;
    }

    /**
     * Get the configurationReference property: Optional, Specifies the uri to an azure blob that will replace the
     * default configuration for the package if provided.
     * 
     * @return the configurationReference value.
     */
    public String configurationReference() {
        return this.configurationReference;
    }

    /**
     * Set the configurationReference property: Optional, Specifies the uri to an azure blob that will replace the
     * default configuration for the package if provided.
     * 
     * @param configurationReference the configurationReference value to set.
     * @return the VMGalleryApplication object itself.
     */
    public VMGalleryApplication withConfigurationReference(String configurationReference) {
        this.configurationReference = configurationReference;
        return this;
    }

    /**
     * Get the treatFailureAsDeploymentFailure property: Optional, If true, any failure for any operation in the
     * VmApplication will fail the deployment.
     * 
     * @return the treatFailureAsDeploymentFailure value.
     */
    public Boolean treatFailureAsDeploymentFailure() {
        return this.treatFailureAsDeploymentFailure;
    }

    /**
     * Set the treatFailureAsDeploymentFailure property: Optional, If true, any failure for any operation in the
     * VmApplication will fail the deployment.
     * 
     * @param treatFailureAsDeploymentFailure the treatFailureAsDeploymentFailure value to set.
     * @return the VMGalleryApplication object itself.
     */
    public VMGalleryApplication withTreatFailureAsDeploymentFailure(Boolean treatFailureAsDeploymentFailure) {
        this.treatFailureAsDeploymentFailure = treatFailureAsDeploymentFailure;
        return this;
    }

    /**
     * Get the enableAutomaticUpgrade property: If set to true, when a new Gallery Application version is available in
     * PIR/SIG, it will be automatically updated for the VM/VMSS.
     * 
     * @return the enableAutomaticUpgrade value.
     */
    public Boolean enableAutomaticUpgrade() {
        return this.enableAutomaticUpgrade;
    }

    /**
     * Set the enableAutomaticUpgrade property: If set to true, when a new Gallery Application version is available in
     * PIR/SIG, it will be automatically updated for the VM/VMSS.
     * 
     * @param enableAutomaticUpgrade the enableAutomaticUpgrade value to set.
     * @return the VMGalleryApplication object itself.
     */
    public VMGalleryApplication withEnableAutomaticUpgrade(Boolean enableAutomaticUpgrade) {
        this.enableAutomaticUpgrade = enableAutomaticUpgrade;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (packageReferenceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property packageReferenceId in model VMGalleryApplication"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VMGalleryApplication.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("packageReferenceId", this.packageReferenceId);
        jsonWriter.writeStringField("tags", this.tags);
        jsonWriter.writeNumberField("order", this.order);
        jsonWriter.writeStringField("configurationReference", this.configurationReference);
        jsonWriter.writeBooleanField("treatFailureAsDeploymentFailure", this.treatFailureAsDeploymentFailure);
        jsonWriter.writeBooleanField("enableAutomaticUpgrade", this.enableAutomaticUpgrade);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VMGalleryApplication from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VMGalleryApplication if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VMGalleryApplication.
     */
    public static VMGalleryApplication fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VMGalleryApplication deserializedVMGalleryApplication = new VMGalleryApplication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("packageReferenceId".equals(fieldName)) {
                    deserializedVMGalleryApplication.packageReferenceId = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    deserializedVMGalleryApplication.tags = reader.getString();
                } else if ("order".equals(fieldName)) {
                    deserializedVMGalleryApplication.order = reader.getNullable(JsonReader::getInt);
                } else if ("configurationReference".equals(fieldName)) {
                    deserializedVMGalleryApplication.configurationReference = reader.getString();
                } else if ("treatFailureAsDeploymentFailure".equals(fieldName)) {
                    deserializedVMGalleryApplication.treatFailureAsDeploymentFailure
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableAutomaticUpgrade".equals(fieldName)) {
                    deserializedVMGalleryApplication.enableAutomaticUpgrade
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVMGalleryApplication;
        });
    }
}
