// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies a list of virtual machine instance IDs from the VM scale set.
 */
@Fluent
public final class VirtualMachineScaleSetVMInstanceRequiredIDs
    implements JsonSerializable<VirtualMachineScaleSetVMInstanceRequiredIDs> {
    /*
     * The virtual machine scale set instance ids.
     */
    private List<String> instanceIds;

    /**
     * Creates an instance of VirtualMachineScaleSetVMInstanceRequiredIDs class.
     */
    public VirtualMachineScaleSetVMInstanceRequiredIDs() {
    }

    /**
     * Get the instanceIds property: The virtual machine scale set instance ids.
     * 
     * @return the instanceIds value.
     */
    public List<String> instanceIds() {
        return this.instanceIds;
    }

    /**
     * Set the instanceIds property: The virtual machine scale set instance ids.
     * 
     * @param instanceIds the instanceIds value to set.
     * @return the VirtualMachineScaleSetVMInstanceRequiredIDs object itself.
     */
    public VirtualMachineScaleSetVMInstanceRequiredIDs withInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (instanceIds() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property instanceIds in model VirtualMachineScaleSetVMInstanceRequiredIDs"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetVMInstanceRequiredIDs.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("instanceIds", this.instanceIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetVMInstanceRequiredIDs from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetVMInstanceRequiredIDs if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetVMInstanceRequiredIDs.
     */
    public static VirtualMachineScaleSetVMInstanceRequiredIDs fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMInstanceRequiredIDs deserializedVirtualMachineScaleSetVMInstanceRequiredIDs
                = new VirtualMachineScaleSetVMInstanceRequiredIDs();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("instanceIds".equals(fieldName)) {
                    List<String> instanceIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedVirtualMachineScaleSetVMInstanceRequiredIDs.instanceIds = instanceIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetVMInstanceRequiredIDs;
        });
    }
}
