/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.CapacityReservationsClient;
import com.azure.resourcemanager.compute.fluent.models.CapacityReservationInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.CapacityReservationInstanceViewTypes;
import com.azure.resourcemanager.compute.models.CapacityReservationListResult;
import com.azure.resourcemanager.compute.models.CapacityReservationUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CapacityReservationsClientImpl
implements CapacityReservationsClient {
    private final CapacityReservationsService service;
    private final ComputeManagementClientImpl client;

    CapacityReservationsClientImpl(ComputeManagementClientImpl client) {
        this.service = (CapacityReservationsService)RestProxy.create(CapacityReservationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (capacityReservationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, capacityReservationName, "2024-11-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (capacityReservationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, capacityReservationName, "2024-11-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CapacityReservationInner>, CapacityReservationInner> beginCreateOrUpdateAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CapacityReservationInner.class), (Type)((Object)CapacityReservationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CapacityReservationInner>, CapacityReservationInner> beginCreateOrUpdateAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CapacityReservationInner.class), (Type)((Object)CapacityReservationInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CapacityReservationInner>, CapacityReservationInner> beginCreateOrUpdate(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CapacityReservationInner>, CapacityReservationInner> beginCreateOrUpdate(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CapacityReservationInner> createOrUpdateAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CapacityReservationInner> createOrUpdateAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapacityReservationInner createOrUpdate(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters) {
        return (CapacityReservationInner)((Object)this.createOrUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapacityReservationInner createOrUpdate(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInner parameters, Context context) {
        return (CapacityReservationInner)((Object)this.createOrUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (capacityReservationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, capacityReservationName, "2024-11-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (capacityReservationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, capacityReservationName, "2024-11-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CapacityReservationInner>, CapacityReservationInner> beginUpdateAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CapacityReservationInner.class), (Type)((Object)CapacityReservationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CapacityReservationInner>, CapacityReservationInner> beginUpdateAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)CapacityReservationInner.class), (Type)((Object)CapacityReservationInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CapacityReservationInner>, CapacityReservationInner> beginUpdate(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CapacityReservationInner>, CapacityReservationInner> beginUpdate(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CapacityReservationInner> updateAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CapacityReservationInner> updateAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapacityReservationInner update(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters) {
        return (CapacityReservationInner)((Object)this.updateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapacityReservationInner update(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationUpdate parameters, Context context) {
        return (CapacityReservationInner)((Object)this.updateAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (capacityReservationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, capacityReservationName, "2024-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (capacityReservationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, capacityReservationName, "2024-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName) {
        return this.beginDeleteAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName) {
        return this.beginDeleteAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName) {
        this.deleteAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, Context context) {
        this.deleteAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CapacityReservationInner>> getWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInstanceViewTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (capacityReservationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, capacityReservationName, expand, "2024-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CapacityReservationInner>> getWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInstanceViewTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (capacityReservationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, capacityReservationName, expand, "2024-11-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CapacityReservationInner> getAsync(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName) {
        CapacityReservationInstanceViewTypes expand = null;
        return this.getWithResponseAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, expand).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CapacityReservationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CapacityReservationInner> getWithResponse(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName, CapacityReservationInstanceViewTypes expand, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, capacityReservationGroupName, capacityReservationName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapacityReservationInner get(String resourceGroupName, String capacityReservationGroupName, String capacityReservationName) {
        CapacityReservationInstanceViewTypes expand = null;
        return (CapacityReservationInner)((Object)this.getWithResponse(resourceGroupName, capacityReservationGroupName, capacityReservationName, expand, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationInner>> listByCapacityReservationGroupSinglePageAsync(String resourceGroupName, String capacityReservationGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByCapacityReservationGroup(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, "2024-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationListResult)res.getValue()).value(), ((CapacityReservationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationInner>> listByCapacityReservationGroupSinglePageAsync(String resourceGroupName, String capacityReservationGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByCapacityReservationGroup(this.client.getEndpoint(), resourceGroupName, capacityReservationGroupName, "2024-11-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationListResult)res.getValue()).value(), ((CapacityReservationListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CapacityReservationInner> listByCapacityReservationGroupAsync(String resourceGroupName, String capacityReservationGroupName) {
        return new PagedFlux(() -> this.listByCapacityReservationGroupSinglePageAsync(resourceGroupName, capacityReservationGroupName), nextLink -> this.listByCapacityReservationGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CapacityReservationInner> listByCapacityReservationGroupAsync(String resourceGroupName, String capacityReservationGroupName, Context context) {
        return new PagedFlux(() -> this.listByCapacityReservationGroupSinglePageAsync(resourceGroupName, capacityReservationGroupName, context), nextLink -> this.listByCapacityReservationGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CapacityReservationInner> listByCapacityReservationGroup(String resourceGroupName, String capacityReservationGroupName) {
        return new PagedIterable(this.listByCapacityReservationGroupAsync(resourceGroupName, capacityReservationGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CapacityReservationInner> listByCapacityReservationGroup(String resourceGroupName, String capacityReservationGroupName, Context context) {
        return new PagedIterable(this.listByCapacityReservationGroupAsync(resourceGroupName, capacityReservationGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationInner>> listByCapacityReservationGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByCapacityReservationGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationListResult)res.getValue()).value(), ((CapacityReservationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationInner>> listByCapacityReservationGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByCapacityReservationGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationListResult)res.getValue()).value(), ((CapacityReservationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    public static interface CapacityReservationsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}/capacityReservations/{capacityReservationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="capacityReservationGroupName") String var3, @PathParam(value="capacityReservationName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") CapacityReservationInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}/capacityReservations/{capacityReservationName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="capacityReservationGroupName") String var3, @PathParam(value="capacityReservationName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") CapacityReservationUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}/capacityReservations/{capacityReservationName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="capacityReservationGroupName") String var3, @PathParam(value="capacityReservationName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}/capacityReservations/{capacityReservationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="capacityReservationGroupName") String var3, @PathParam(value="capacityReservationName") String var4, @QueryParam(value="$expand") CapacityReservationInstanceViewTypes var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}/capacityReservations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationListResult>> listByCapacityReservationGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="capacityReservationGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationListResult>> listByCapacityReservationGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

