/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VMGalleryApplication
implements JsonSerializable<VMGalleryApplication> {
    private String tags;
    private Integer order;
    private String packageReferenceId;
    private String configurationReference;
    private Boolean treatFailureAsDeploymentFailure;
    private Boolean enableAutomaticUpgrade;
    private static final ClientLogger LOGGER = new ClientLogger(VMGalleryApplication.class);

    public String tags() {
        return this.tags;
    }

    public VMGalleryApplication withTags(String tags) {
        this.tags = tags;
        return this;
    }

    public Integer order() {
        return this.order;
    }

    public VMGalleryApplication withOrder(Integer order) {
        this.order = order;
        return this;
    }

    public String packageReferenceId() {
        return this.packageReferenceId;
    }

    public VMGalleryApplication withPackageReferenceId(String packageReferenceId) {
        this.packageReferenceId = packageReferenceId;
        return this;
    }

    public String configurationReference() {
        return this.configurationReference;
    }

    public VMGalleryApplication withConfigurationReference(String configurationReference) {
        this.configurationReference = configurationReference;
        return this;
    }

    public Boolean treatFailureAsDeploymentFailure() {
        return this.treatFailureAsDeploymentFailure;
    }

    public VMGalleryApplication withTreatFailureAsDeploymentFailure(Boolean treatFailureAsDeploymentFailure) {
        this.treatFailureAsDeploymentFailure = treatFailureAsDeploymentFailure;
        return this;
    }

    public Boolean enableAutomaticUpgrade() {
        return this.enableAutomaticUpgrade;
    }

    public VMGalleryApplication withEnableAutomaticUpgrade(Boolean enableAutomaticUpgrade) {
        this.enableAutomaticUpgrade = enableAutomaticUpgrade;
        return this;
    }

    public void validate() {
        if (this.packageReferenceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property packageReferenceId in model VMGalleryApplication"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("packageReferenceId", this.packageReferenceId);
        jsonWriter.writeStringField("tags", this.tags);
        jsonWriter.writeNumberField("order", (Number)this.order);
        jsonWriter.writeStringField("configurationReference", this.configurationReference);
        jsonWriter.writeBooleanField("treatFailureAsDeploymentFailure", this.treatFailureAsDeploymentFailure);
        jsonWriter.writeBooleanField("enableAutomaticUpgrade", this.enableAutomaticUpgrade);
        return jsonWriter.writeEndObject();
    }

    public static VMGalleryApplication fromJson(JsonReader jsonReader) throws IOException {
        return (VMGalleryApplication)jsonReader.readObject(reader -> {
            VMGalleryApplication deserializedVMGalleryApplication = new VMGalleryApplication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packageReferenceId".equals(fieldName)) {
                    deserializedVMGalleryApplication.packageReferenceId = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    deserializedVMGalleryApplication.tags = reader.getString();
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedVMGalleryApplication.order = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("configurationReference".equals(fieldName)) {
                    deserializedVMGalleryApplication.configurationReference = reader.getString();
                    continue;
                }
                if ("treatFailureAsDeploymentFailure".equals(fieldName)) {
                    deserializedVMGalleryApplication.treatFailureAsDeploymentFailure = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticUpgrade".equals(fieldName)) {
                    deserializedVMGalleryApplication.enableAutomaticUpgrade = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVMGalleryApplication;
        });
    }
}

