// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiError;
import com.azure.resourcemanager.compute.models.RollingUpgradePolicy;
import com.azure.resourcemanager.compute.models.RollingUpgradeProgressInfo;
import com.azure.resourcemanager.compute.models.RollingUpgradeRunningStatus;
import java.io.IOException;
import java.util.Map;

/**
 * The status of the latest virtual machine scale set rolling upgrade.
 */
@Fluent
public final class RollingUpgradeStatusInfoInner extends Resource {
    /*
     * The status of the latest virtual machine scale set rolling upgrade.
     */
    private RollingUpgradeStatusInfoProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RollingUpgradeStatusInfoInner class.
     */
    public RollingUpgradeStatusInfoInner() {
    }

    /**
     * Get the innerProperties property: The status of the latest virtual machine scale set rolling upgrade.
     * 
     * @return the innerProperties value.
     */
    private RollingUpgradeStatusInfoProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RollingUpgradeStatusInfoInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RollingUpgradeStatusInfoInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the policy property: The rolling upgrade policies applied for this upgrade.
     * 
     * @return the policy value.
     */
    public RollingUpgradePolicy policy() {
        return this.innerProperties() == null ? null : this.innerProperties().policy();
    }

    /**
     * Get the runningStatus property: Information about the current running state of the overall upgrade.
     * 
     * @return the runningStatus value.
     */
    public RollingUpgradeRunningStatus runningStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().runningStatus();
    }

    /**
     * Get the progress property: Information about the number of virtual machine instances in each upgrade state.
     * 
     * @return the progress value.
     */
    public RollingUpgradeProgressInfo progress() {
        return this.innerProperties() == null ? null : this.innerProperties().progress();
    }

    /**
     * Get the error property: Error details for this upgrade, if there are any.
     * 
     * @return the error value.
     */
    public ApiError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RollingUpgradeStatusInfoInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RollingUpgradeStatusInfoInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RollingUpgradeStatusInfoInner.
     */
    public static RollingUpgradeStatusInfoInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RollingUpgradeStatusInfoInner deserializedRollingUpgradeStatusInfoInner
                = new RollingUpgradeStatusInfoInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRollingUpgradeStatusInfoInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.innerProperties
                        = RollingUpgradeStatusInfoProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRollingUpgradeStatusInfoInner;
        });
    }
}
