// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Contains the list of gallery applications that should be made available to the VM/VMSS.
 */
@Fluent
public final class ApplicationProfile implements JsonSerializable<ApplicationProfile> {
    /*
     * Specifies the gallery applications that should be made available to the VM/VMSS
     */
    private List<VMGalleryApplication> galleryApplications;

    /**
     * Creates an instance of ApplicationProfile class.
     */
    public ApplicationProfile() {
    }

    /**
     * Get the galleryApplications property: Specifies the gallery applications that should be made available to the
     * VM/VMSS.
     * 
     * @return the galleryApplications value.
     */
    public List<VMGalleryApplication> galleryApplications() {
        return this.galleryApplications;
    }

    /**
     * Set the galleryApplications property: Specifies the gallery applications that should be made available to the
     * VM/VMSS.
     * 
     * @param galleryApplications the galleryApplications value to set.
     * @return the ApplicationProfile object itself.
     */
    public ApplicationProfile withGalleryApplications(List<VMGalleryApplication> galleryApplications) {
        this.galleryApplications = galleryApplications;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (galleryApplications() != null) {
            galleryApplications().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("galleryApplications", this.galleryApplications,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationProfile.
     */
    public static ApplicationProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationProfile deserializedApplicationProfile = new ApplicationProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("galleryApplications".equals(fieldName)) {
                    List<VMGalleryApplication> galleryApplications
                        = reader.readArray(reader1 -> VMGalleryApplication.fromJson(reader1));
                    deserializedApplicationProfile.galleryApplications = galleryApplications;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationProfile;
        });
    }
}
