// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes the OS profile for the cloud service.
 */
@Fluent
public final class CloudServiceOsProfile implements JsonSerializable<CloudServiceOsProfile> {
    /*
     * Specifies set of certificates that should be installed onto the role instances.
     */
    private List<CloudServiceVaultSecretGroup> secrets;

    /**
     * Creates an instance of CloudServiceOsProfile class.
     */
    public CloudServiceOsProfile() {
    }

    /**
     * Get the secrets property: Specifies set of certificates that should be installed onto the role instances.
     * 
     * @return the secrets value.
     */
    public List<CloudServiceVaultSecretGroup> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Specifies set of certificates that should be installed onto the role instances.
     * 
     * @param secrets the secrets value to set.
     * @return the CloudServiceOsProfile object itself.
     */
    public CloudServiceOsProfile withSecrets(List<CloudServiceVaultSecretGroup> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (secrets() != null) {
            secrets().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CloudServiceOsProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CloudServiceOsProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CloudServiceOsProfile.
     */
    public static CloudServiceOsProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudServiceOsProfile deserializedCloudServiceOsProfile = new CloudServiceOsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("secrets".equals(fieldName)) {
                    List<CloudServiceVaultSecretGroup> secrets
                        = reader.readArray(reader1 -> CloudServiceVaultSecretGroup.fromJson(reader1));
                    deserializedCloudServiceOsProfile.secrets = secrets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCloudServiceOsProfile;
        });
    }
}
