// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Disk Restore Point details.
 */
@Fluent
public final class DiskRestorePointAttributes extends SubResourceReadOnly {
    /*
     * Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input
     * while creating a restore point.
     */
    private RestorePointEncryption encryption;

    /*
     * Resource Id of the source disk restore point.
     */
    private ApiEntityReference sourceDiskRestorePoint;

    /*
     * Resource Id
     */
    private String id;

    /**
     * Creates an instance of DiskRestorePointAttributes class.
     */
    public DiskRestorePointAttributes() {
    }

    /**
     * Get the encryption property: Encryption at rest settings for disk restore point. It is an optional property that
     * can be specified in the input while creating a restore point.
     * 
     * @return the encryption value.
     */
    public RestorePointEncryption encryption() {
        return this.encryption;
    }

    /**
     * Set the encryption property: Encryption at rest settings for disk restore point. It is an optional property that
     * can be specified in the input while creating a restore point.
     * 
     * @param encryption the encryption value to set.
     * @return the DiskRestorePointAttributes object itself.
     */
    public DiskRestorePointAttributes withEncryption(RestorePointEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    /**
     * Get the sourceDiskRestorePoint property: Resource Id of the source disk restore point.
     * 
     * @return the sourceDiskRestorePoint value.
     */
    public ApiEntityReference sourceDiskRestorePoint() {
        return this.sourceDiskRestorePoint;
    }

    /**
     * Set the sourceDiskRestorePoint property: Resource Id of the source disk restore point.
     * 
     * @param sourceDiskRestorePoint the sourceDiskRestorePoint value to set.
     * @return the DiskRestorePointAttributes object itself.
     */
    public DiskRestorePointAttributes withSourceDiskRestorePoint(ApiEntityReference sourceDiskRestorePoint) {
        this.sourceDiskRestorePoint = sourceDiskRestorePoint;
        return this;
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (encryption() != null) {
            encryption().validate();
        }
        if (sourceDiskRestorePoint() != null) {
            sourceDiskRestorePoint().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("encryption", this.encryption);
        jsonWriter.writeJsonField("sourceDiskRestorePoint", this.sourceDiskRestorePoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskRestorePointAttributes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskRestorePointAttributes if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskRestorePointAttributes.
     */
    public static DiskRestorePointAttributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskRestorePointAttributes deserializedDiskRestorePointAttributes = new DiskRestorePointAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDiskRestorePointAttributes.id = reader.getString();
                } else if ("encryption".equals(fieldName)) {
                    deserializedDiskRestorePointAttributes.encryption = RestorePointEncryption.fromJson(reader);
                } else if ("sourceDiskRestorePoint".equals(fieldName)) {
                    deserializedDiskRestorePointAttributes.sourceDiskRestorePoint = ApiEntityReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskRestorePointAttributes;
        });
    }
}
