// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the security related information for the resource.
 */
@Fluent
public final class DiskSecurityProfile implements JsonSerializable<DiskSecurityProfile> {
    /*
     * Specifies the SecurityType of the VM. Applicable for OS disks only.
     */
    private DiskSecurityTypes securityType;

    /*
     * ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer
     * managed key
     */
    private String secureVMDiskEncryptionSetId;

    /**
     * Creates an instance of DiskSecurityProfile class.
     */
    public DiskSecurityProfile() {
    }

    /**
     * Get the securityType property: Specifies the SecurityType of the VM. Applicable for OS disks only.
     * 
     * @return the securityType value.
     */
    public DiskSecurityTypes securityType() {
        return this.securityType;
    }

    /**
     * Set the securityType property: Specifies the SecurityType of the VM. Applicable for OS disks only.
     * 
     * @param securityType the securityType value to set.
     * @return the DiskSecurityProfile object itself.
     */
    public DiskSecurityProfile withSecurityType(DiskSecurityTypes securityType) {
        this.securityType = securityType;
        return this;
    }

    /**
     * Get the secureVMDiskEncryptionSetId property: ResourceId of the disk encryption set associated to Confidential VM
     * supported disk encrypted with customer managed key.
     * 
     * @return the secureVMDiskEncryptionSetId value.
     */
    public String secureVMDiskEncryptionSetId() {
        return this.secureVMDiskEncryptionSetId;
    }

    /**
     * Set the secureVMDiskEncryptionSetId property: ResourceId of the disk encryption set associated to Confidential VM
     * supported disk encrypted with customer managed key.
     * 
     * @param secureVMDiskEncryptionSetId the secureVMDiskEncryptionSetId value to set.
     * @return the DiskSecurityProfile object itself.
     */
    public DiskSecurityProfile withSecureVMDiskEncryptionSetId(String secureVMDiskEncryptionSetId) {
        this.secureVMDiskEncryptionSetId = secureVMDiskEncryptionSetId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("securityType", this.securityType == null ? null : this.securityType.toString());
        jsonWriter.writeStringField("secureVMDiskEncryptionSetId", this.secureVMDiskEncryptionSetId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskSecurityProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskSecurityProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskSecurityProfile.
     */
    public static DiskSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskSecurityProfile deserializedDiskSecurityProfile = new DiskSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("securityType".equals(fieldName)) {
                    deserializedDiskSecurityProfile.securityType = DiskSecurityTypes.fromString(reader.getString());
                } else if ("secureVMDiskEncryptionSetId".equals(fieldName)) {
                    deserializedDiskSecurityProfile.secureVMDiskEncryptionSetId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskSecurityProfile;
        });
    }
}
