// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a cloud service IP Configuration.
 */
@Fluent
public final class LoadBalancerFrontendIpConfigurationProperties
    implements JsonSerializable<LoadBalancerFrontendIpConfigurationProperties> {
    /*
     * The reference to the public ip address resource.
     */
    private SubResource publicIpAddress;

    /*
     * The reference to the virtual network subnet resource.
     */
    private SubResource subnet;

    /*
     * The virtual network private IP address of the IP configuration.
     */
    private String privateIpAddress;

    /**
     * Creates an instance of LoadBalancerFrontendIpConfigurationProperties class.
     */
    public LoadBalancerFrontendIpConfigurationProperties() {
    }

    /**
     * Get the publicIpAddress property: The reference to the public ip address resource.
     * 
     * @return the publicIpAddress value.
     */
    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: The reference to the public ip address resource.
     * 
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the LoadBalancerFrontendIpConfigurationProperties object itself.
     */
    public LoadBalancerFrontendIpConfigurationProperties withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Get the subnet property: The reference to the virtual network subnet resource.
     * 
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The reference to the virtual network subnet resource.
     * 
     * @param subnet the subnet value to set.
     * @return the LoadBalancerFrontendIpConfigurationProperties object itself.
     */
    public LoadBalancerFrontendIpConfigurationProperties withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the privateIpAddress property: The virtual network private IP address of the IP configuration.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Set the privateIpAddress property: The virtual network private IP address of the IP configuration.
     * 
     * @param privateIpAddress the privateIpAddress value to set.
     * @return the LoadBalancerFrontendIpConfigurationProperties object itself.
     */
    public LoadBalancerFrontendIpConfigurationProperties withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("publicIPAddress", this.publicIpAddress);
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoadBalancerFrontendIpConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoadBalancerFrontendIpConfigurationProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoadBalancerFrontendIpConfigurationProperties.
     */
    public static LoadBalancerFrontendIpConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoadBalancerFrontendIpConfigurationProperties deserializedLoadBalancerFrontendIpConfigurationProperties
                = new LoadBalancerFrontendIpConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publicIPAddress".equals(fieldName)) {
                    deserializedLoadBalancerFrontendIpConfigurationProperties.publicIpAddress
                        = SubResource.fromJson(reader);
                } else if ("subnet".equals(fieldName)) {
                    deserializedLoadBalancerFrontendIpConfigurationProperties.subnet = SubResource.fromJson(reader);
                } else if ("privateIPAddress".equals(fieldName)) {
                    deserializedLoadBalancerFrontendIpConfigurationProperties.privateIpAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoadBalancerFrontendIpConfigurationProperties;
        });
    }
}
